/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.recorder.ConsoleRecorder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public final class ScxLogging {
    private static final ScxLoggerConfig DEFAULT_CONFIG = new ScxLoggerConfig().setLevel(System.Logger.Level.ERROR).setStackTrace(false).addRecorder(new ConsoleRecorder());
    private static final ScxLoggerConfig ROOT_CONFIG = new ScxLoggerConfig(DEFAULT_CONFIG);
    private static final ConcurrentHashMap<String, ScxLogger> LOGGERS = new ConcurrentHashMap();
    private static final LinkedHashMap<String, ScxLoggerConfig> CONFIGS = new LinkedHashMap();
    private static final ReentrantReadWriteLock CONFIGS_LOCK = new ReentrantReadWriteLock();

    public static ScxLoggerConfig rootConfig() {
        return ROOT_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScxLoggerConfig findConfig(String name) {
        CONFIGS_LOCK.readLock().lock();
        try {
            for (Map.Entry<String, ScxLoggerConfig> entry : CONFIGS.entrySet()) {
                boolean b = Pattern.matches(entry.getKey(), name);
                if (!b) continue;
                ScxLoggerConfig scxLoggerConfig = entry.getValue();
                return scxLoggerConfig;
            }
            Iterator<Map.Entry<String, ScxLoggerConfig>> iterator = null;
            return iterator;
        }
        finally {
            CONFIGS_LOCK.readLock().unlock();
        }
    }

    private static ScxLogger createLogger(String name) {
        ScxLogger scxLogger = new ScxLogger(name, new ScxLoggerConfig(ROOT_CONFIG));
        ScxLoggerConfig config = ScxLogging.findConfig(name);
        if (config != null) {
            scxLogger.config().updateConfig(config);
        }
        return scxLogger;
    }

    public static ScxLogger getLogger(String name) {
        return LOGGERS.computeIfAbsent(name, ScxLogging::createLogger);
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLogging.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(String name, ScxLoggerConfig newConfig) {
        CONFIGS_LOCK.writeLock().lock();
        try {
            CONFIGS.putFirst(name, newConfig);
            for (ScxLogger value : LOGGERS.values()) {
                boolean b = Pattern.matches(name, value.name());
                if (!b) continue;
                value.config().updateConfig(newConfig);
            }
        }
        finally {
            CONFIGS_LOCK.writeLock().unlock();
        }
    }

    public static void removeConfig(String name) {
        CONFIGS_LOCK.writeLock().lock();
        try {
            CONFIGS.remove(name);
        }
        finally {
            CONFIGS_LOCK.writeLock().unlock();
        }
    }
}

