/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.jdk;

import cool.scx.logging.ScxLogger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ScxJDKLogger
implements System.Logger {
    private final ScxLogger scxLogger;

    public ScxJDKLogger(ScxLogger scxLogger) {
        this.scxLogger = scxLogger;
    }

    private static String formatMessage(String format, Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return format;
        }
        try {
            return MessageFormat.format(format, parameters);
        }
        catch (Exception ex) {
            return format;
        }
    }

    private static String getResourceString(ResourceBundle bundle, String key) {
        if (bundle == null || key == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException x) {
            return key;
        }
    }

    private static Throwable getThrowableCandidate(Object[] argArray) {
        if (argArray != null && argArray.length != 0) {
            Throwable e;
            Object lastEntry = argArray[argArray.length - 1];
            return lastEntry instanceof Throwable ? (e = (Throwable)lastEntry) : null;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.scxLogger.name();
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.scxLogger.isLoggable(level);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable t) {
        this.scxLogger.log(level, ScxJDKLogger.getResourceString(bundle, msg), t);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        Throwable t = ScxJDKLogger.getThrowableCandidate(params);
        if (t != null) {
            params = Arrays.copyOf(params, params.length - 1);
        }
        this.scxLogger.log(level, ScxJDKLogger.formatMessage(ScxJDKLogger.getResourceString(bundle, format), params), t);
    }
}

