/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.log4j;

import cool.scx.logging.ScxLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public final class ScxLog4jLogger
extends AbstractLogger {
    private final ScxLogger scxLogger;

    public ScxLog4jLogger(ScxLogger scxLogger) {
        super(scxLogger.name());
        this.scxLogger = scxLogger;
    }

    private static System.Logger.Level toJDKLevel(Level level) {
        if (level == Level.OFF) {
            return System.Logger.Level.OFF;
        }
        if (level == Level.FATAL || level == Level.ERROR) {
            return System.Logger.Level.ERROR;
        }
        if (level == Level.WARN) {
            return System.Logger.Level.WARNING;
        }
        if (level == Level.INFO) {
            return System.Logger.Level.INFO;
        }
        if (level == Level.DEBUG) {
            return System.Logger.Level.DEBUG;
        }
        if (level == Level.TRACE) {
            return System.Logger.Level.TRACE;
        }
        if (level == Level.ALL) {
            return System.Logger.Level.ALL;
        }
        throw new IllegalArgumentException();
    }

    private static Level toLog4jLevel(System.Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.OFF -> Level.OFF;
            case System.Logger.Level.ERROR -> Level.ERROR;
            case System.Logger.Level.WARNING -> Level.WARN;
            case System.Logger.Level.INFO -> Level.INFO;
            case System.Logger.Level.DEBUG -> Level.DEBUG;
            case System.Logger.Level.TRACE -> Level.TRACE;
            case System.Logger.Level.ALL -> Level.ALL;
        };
    }

    private boolean isLoggable(Level level) {
        return this.scxLogger.isLoggable(ScxLog4jLogger.toJDKLevel(level));
    }

    public Level getLevel() {
        return ScxLog4jLogger.toLog4jLevel(this.scxLogger.config().level());
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isLoggable(level);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isLoggable(level);
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        this.scxLogger.log0(ScxLog4jLogger.toJDKLevel(level), message.getFormattedMessage(), t);
    }
}

