/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.enumeration.HttpMethod;
import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.ScxMvcHelper;
import cool.scx.mvc.annotation.ScxMapping;
import cool.scx.util.CaseUtils;
import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.URIBuilder;
import io.vertx.core.Handler;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class ScxMappingHandler
implements Handler<RoutingContext> {
    public final Method method;
    public final boolean isVoid;
    public final Parameter[] parameters;
    public final Object instance;
    public final Class<?> clazz;
    public final String originalUrl;
    public final HttpMethod[] httpMethods;
    private final ScxMvc scxMvc;
    private final int order;
    private RouteState routeState;

    ScxMappingHandler(Method method, Class<?> clazz, Object instance, ScxMvc scxMvc) {
        this.scxMvc = scxMvc;
        this.clazz = clazz;
        this.method = method;
        this.method.setAccessible(true);
        this.isVoid = method.getReturnType().equals(Void.TYPE);
        this.parameters = method.getParameters();
        this.instance = instance;
        ScxMapping classScxMapping = clazz.getAnnotation(ScxMapping.class);
        ScxMapping methodScxMapping = method.getAnnotation(ScxMapping.class);
        this.originalUrl = this.initOriginalUrl(classScxMapping, methodScxMapping);
        this.httpMethods = ScxMappingHandler.initHttpMethod(methodScxMapping);
        this.order = methodScxMapping.order();
    }

    private static HttpMethod[] initHttpMethod(ScxMapping methodScxMapping) {
        return (HttpMethod[])Stream.of(methodScxMapping.method()).distinct().toArray(HttpMethod[]::new);
    }

    private String initOriginalUrl(ScxMapping classScxMapping, ScxMapping methodScxMapping) {
        String[] urlArray = new String[]{"", ""};
        if (!methodScxMapping.ignoreParentUrl() && classScxMapping != null) {
            urlArray[0] = classScxMapping.value();
        }
        urlArray[1] = methodScxMapping.useNameAsUrl() && "".equals(methodScxMapping.value()) ? CaseUtils.toKebab((String)this.method.getName()) : methodScxMapping.value();
        return URIBuilder.addSlashStart((String)URIBuilder.join((String[])urlArray));
    }

    public void handle(RoutingContext context) {
        ScxMvc._routingContext(context);
        try {
            this.scxMvc.interceptor().preHandle(context, this);
            Object[] methodParameters = this.scxMvc.buildMethodParameters(this.parameters, context);
            Object tempResult = this.method.invoke(this.instance, methodParameters);
            Object finalResult = this.scxMvc.interceptor().postHandle(context, this, tempResult);
            if (!this.isVoid && ScxMvcHelper.responseCanUse(context)) {
                this.scxMvc.findReturnValueHandler(finalResult).handle(finalResult, context);
            }
        }
        catch (Throwable e) {
            throw new ScxExceptionHelper.ScxWrappedRuntimeException(e instanceof InvocationTargetException ? e.getCause() : e);
        }
        finally {
            ScxMvc._clearRoutingContext();
        }
    }

    void setRouteState(RouteState route) {
        this.routeState = route;
    }

    RouteState routeState() {
        return this.routeState;
    }

    public int order() {
        return this.order;
    }

    record RouteState(Map<String, Object> metadata, String path, String name, int order, boolean enabled, Set<HttpMethod> methods, Set<MIMEHeader> consumes, boolean emptyBodyPermittedWithConsumes, Set<MIMEHeader> produces, boolean added, Pattern pattern, List<String> groups, boolean useNormalizedPath, Set<String> namedGroupsInRegex, Pattern virtualHostPattern, boolean pathEndsWithSlash, boolean exclusive, boolean exactPath) {
        int getGroupsOrder() {
            return this.groups == null ? 0 : this.groups.size();
        }

        int getExactPathOrder() {
            return this.exactPath ? 0 : 1;
        }
    }
}

