/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.JsonBodyWrapper;
import cool.scx.util.ObjectUtils;
import io.vertx.ext.web.RoutingContext;

public final class DataJson
implements BaseVo {
    private final JsonBodyWrapper<Object> jsonBodyWrapper;

    private DataJson(String message) {
        this.jsonBodyWrapper = new JsonBodyWrapper<Object>(message, null);
    }

    public static DataJson ok() {
        return new DataJson("ok");
    }

    public static DataJson fail() {
        return new DataJson("fail");
    }

    public static DataJson fail(String failMessage) {
        return new DataJson(failMessage);
    }

    public DataJson data(Object dataVal) {
        this.jsonBodyWrapper.data = dataVal;
        return this;
    }

    public void accept(RoutingContext context) {
        BaseVo.fillJsonContentType(context.request().response()).end(this.toJson(""));
    }

    public String toJson() throws JsonProcessingException {
        return ObjectUtils.toJson(this.jsonBodyWrapper, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String toJson(String defaultValue) {
        return ObjectUtils.toJson(this.jsonBodyWrapper, (String)defaultValue, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }
}

