/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.ScxWebSocketRoute;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnFrameRoutingContext {
    private static final Logger logger = LoggerFactory.getLogger(OnFrameRoutingContext.class);
    private final WebSocketFrame socketFrame;
    private final ServerWebSocket socket;
    private final Iterator<ScxWebSocketRoute> iter;

    OnFrameRoutingContext(WebSocketFrame socketFrame, ServerWebSocket socket, List<ScxWebSocketRoute> routes) {
        this.socketFrame = socketFrame;
        this.socket = socket;
        this.iter = routes.iterator();
    }

    public void next() {
        while (this.iter.hasNext()) {
            ScxWebSocketRoute next = this.iter.next();
            if (!next.matches(this.socket)) continue;
            if (this.socketFrame.isText()) {
                try {
                    next.baseWebSocketHandler().onTextMessage(this.socketFrame.textData(), this.socketFrame, this.socket, this);
                }
                catch (Exception e) {
                    logger.error("ScxWebSocketRoute : onTextMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
                }
            } else if (this.socketFrame.isBinary()) {
                try {
                    next.baseWebSocketHandler().onBinaryMessage(this.socketFrame.binaryData(), this.socketFrame, this.socket, this);
                }
                catch (Exception e) {
                    logger.error("ScxWebSocketRoute : onBinaryMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
                }
            }
            return;
        }
    }
}

