/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import cool.scx.mvc.ScxTemplateHandler;
import cool.scx.mvc.vo.BaseVo;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class Html {
    private final boolean useTemplate;
    private final String templatePath;
    private final String htmlStr;
    private final Map<String, Object> dataMap = new HashMap<String, Object>();

    private Html(String templatePath, String htmlStr, boolean useTemplate) {
        this.templatePath = templatePath;
        this.htmlStr = htmlStr;
        this.useTemplate = useTemplate;
    }

    public static Html ofString(String htmlStr) {
        return new Html(null, htmlStr, false);
    }

    public static Html of(String templatePath) throws IOException {
        return new Html(templatePath, null, true);
    }

    public Html add(String key, Object value) {
        this.dataMap.put(key, value);
        return this;
    }

    public void accept(RoutingContext context, ScxTemplateHandler templateHandler) throws TemplateException, IOException {
        if (this.useTemplate) {
            this.sendTemplate(context, templateHandler);
        } else {
            this.sendHtmlStr(context);
        }
    }

    public void sendHtmlStr(RoutingContext context) {
        HttpServerResponse response = BaseVo.fillHtmlContentType(context.request().response());
        response.end(this.htmlStr);
    }

    public void sendTemplate(RoutingContext context, ScxTemplateHandler templateHandler) throws IOException, TemplateException {
        if (templateHandler == null) {
            throw new NullPointerException("handler \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        HttpServerResponse response = BaseVo.fillHtmlContentType(context.request().response());
        StringWriter sw = new StringWriter();
        Template template = templateHandler.getTemplateByPath(this.templatePath);
        template.process(this.dataMap, (Writer)sw);
        response.end(sw.toString());
    }
}

