/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import cool.scx.mvc.exception.BadRequestException;
import cool.scx.util.ObjectUtils;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.ext.web.RoutingContext;

public final class ScxMvcRequestInfo {
    private final RoutingContext routingContext;
    private final JsonNode body;
    private final ContentType contentType;

    public ScxMvcRequestInfo(RoutingContext ctx) {
        this.routingContext = ctx;
        this.contentType = ScxMvcRequestInfo.initContentType(ctx);
        this.body = ScxMvcRequestInfo.initBody(ctx, this.contentType);
    }

    public static JsonNode initBody(RoutingContext ctx, ContentType contentType) {
        String bodyAsString = ctx.body().asString();
        if (bodyAsString == null) {
            return null;
        }
        return switch (contentType) {
            case ContentType.JSON -> ScxMvcRequestInfo.readJson(bodyAsString);
            case ContentType.XML -> ScxMvcRequestInfo.readXml(bodyAsString);
            default -> ScxMvcRequestInfo.tryReadOrTextNode(bodyAsString);
        };
    }

    public static JsonNode readJson(String jsonStr) {
        try {
            return ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException(e);
        }
    }

    public static JsonNode readXml(String xmlStr) {
        try {
            return ObjectUtils.xmlMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(xmlStr);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException(e);
        }
    }

    public static JsonNode tryReadOrTextNode(String str) {
        try {
            return ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(str);
        }
        catch (Exception exception) {
            try {
                return ObjectUtils.xmlMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readTree(str);
            }
            catch (JsonProcessingException e) {
                return new TextNode(str);
            }
        }
    }

    public static ContentType initContentType(RoutingContext ctx) {
        String contentType = ctx.request().headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        if (contentType == null) {
            return ContentType.NULL;
        }
        if (contentType.startsWith(HttpHeaderValues.APPLICATION_JSON.toString())) {
            return ContentType.JSON;
        }
        if (contentType.startsWith(HttpHeaderValues.APPLICATION_XML.toString())) {
            return ContentType.XML;
        }
        if (contentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || contentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) {
            return ContentType.FORM;
        }
        return ContentType.OTHER;
    }

    public JsonNode body() {
        return this.body;
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    public static enum ContentType {
        FORM,
        JSON,
        XML,
        OTHER,
        NULL;

    }
}

