/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.mvc.annotation.ScxWebSocketMapping;
import cool.scx.mvc.base.BaseWebSocketHandler;
import cool.scx.mvc.websocket.ScxWebSocketRoute;
import cool.scx.mvc.websocket.ScxWebSocketRouter;
import cool.scx.util.ClassUtils;
import cool.scx.util.URIBuilder;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;

public final class ScxWebSocketMappingRegistrar {
    private static final Comparator<ScxWebSocketRoute> orderComparator = Comparator.comparing(ScxWebSocketRoute::order);
    private final List<ScxWebSocketRoute> scxWebSocketRoutes;

    public ScxWebSocketMappingRegistrar(BeanFactory beanFactory, List<Class<?>> classList) {
        this.scxWebSocketRoutes = ScxWebSocketMappingRegistrar.initScxWebSocketRoutes(beanFactory, classList);
    }

    private static List<ScxWebSocketRoute> initScxWebSocketRoutes(BeanFactory beanFactory, List<Class<?>> classList) {
        List<? extends Class<? extends BaseWebSocketHandler>> filteredClassList = ScxWebSocketMappingRegistrar.filterClass(classList);
        List<ScxWebSocketRoute> routeList = filteredClassList.stream().map(c -> ScxWebSocketMappingRegistrar.createScxWebSocketRoute(beanFactory, c)).toList();
        return ScxWebSocketMappingRegistrar.sortedScxWebSocketRoutes(routeList);
    }

    public static ScxWebSocketRoute createScxWebSocketRoute(BeanFactory beanFactory, Class<? extends BaseWebSocketHandler> c) {
        ScxWebSocketMapping scxWebSocketMapping = c.getAnnotation(ScxWebSocketMapping.class);
        String path = URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{scxWebSocketMapping.value()}));
        int order = scxWebSocketMapping.order();
        BaseWebSocketHandler baseWebSocketHandler = (BaseWebSocketHandler)beanFactory.getBean(c);
        return new ScxWebSocketRoute(order, path, baseWebSocketHandler);
    }

    public static List<? extends Class<? extends BaseWebSocketHandler>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(ScxWebSocketMappingRegistrar::isScxWebSocketRouteClass).map(c -> c).toList();
    }

    public static boolean isScxWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketMapping.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<ScxWebSocketRoute> sortedScxWebSocketRoutes(List<ScxWebSocketRoute> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public ScxWebSocketRouter registerRoute(ScxWebSocketRouter scxWebSocketRouter) {
        for (ScxWebSocketRoute route : this.scxWebSocketRoutes) {
            scxWebSocketRouter.addRoute(route);
        }
        return scxWebSocketRouter;
    }
}

