/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.OnCloseRoutingContext;
import cool.scx.mvc.websocket.OnExceptionRoutingContext;
import cool.scx.mvc.websocket.OnFrameRoutingContext;
import cool.scx.mvc.websocket.OnOpenRoutingContext;
import cool.scx.mvc.websocket.ScxWebSocketRoute;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScxWebSocketRouter
implements Handler<ServerWebSocket> {
    private static final Logger logger = LoggerFactory.getLogger(ScxWebSocketRouter.class);
    private final List<ScxWebSocketRoute> scxWebSocketRoutes = new ArrayList<ScxWebSocketRoute>();

    public ScxWebSocketRouter addRoute(ScxWebSocketRoute scxRoute) {
        this.scxWebSocketRoutes.add(scxRoute);
        return this;
    }

    public List<ScxWebSocketRoute> getRoutes() {
        return new ArrayList<ScxWebSocketRoute>(this.scxWebSocketRoutes);
    }

    public void handle(ServerWebSocket serverWebSocket) {
        if (this.anyMatch(serverWebSocket)) {
            new OnOpenRoutingContext(serverWebSocket, this.scxWebSocketRoutes).next();
            serverWebSocket.frameHandler(h -> new OnFrameRoutingContext((WebSocketFrame)h, serverWebSocket, this.scxWebSocketRoutes).next()).exceptionHandler(e -> new OnExceptionRoutingContext((Throwable)e, serverWebSocket, this.scxWebSocketRoutes).next()).closeHandler(v -> new OnCloseRoutingContext(serverWebSocket, this.scxWebSocketRoutes).next());
        }
    }

    private boolean anyMatch(ServerWebSocket serverWebSocket) {
        boolean anyMatch = this.scxWebSocketRoutes.stream().anyMatch((? super T c) -> c.matches(serverWebSocket));
        if (!anyMatch) {
            serverWebSocket.reject(404);
        }
        return anyMatch;
    }
}

