/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.util.ObjectUtils;
import io.vertx.ext.web.RoutingContext;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Data
implements BaseVo {
    public static DataOfMap ok() {
        return new DataOfMap("ok");
    }

    public static DataOfData ok(Object object) {
        return new DataOfData("ok", object);
    }

    public static DataOfMap fail() {
        return new DataOfMap("fail");
    }

    public static DataOfMap fail(String failMessage) {
        return new DataOfMap(failMessage);
    }

    public void accept(RoutingContext context) {
        BaseVo.fillJsonContentType(context.request().response()).end(this.toJson(""));
    }

    public String toJson() throws JsonProcessingException {
        return ObjectUtils.toJson(this.jsonBodyWrapper(), (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    protected abstract JsonBodyWrapper<?> jsonBodyWrapper();

    public String toJson(String defaultValue) {
        return ObjectUtils.toJson(this.jsonBodyWrapper(), (String)defaultValue, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public static class DataOfMap
    extends Data {
        protected final JsonBodyWrapper<Map<String, Object>> jsonBodyWrapper;

        private DataOfMap(String message) {
            this.jsonBodyWrapper = new JsonBodyWrapper(message, new LinkedHashMap());
        }

        public DataOfMap put(String dataKey, Object dataVal) {
            ((Map)this.jsonBodyWrapper.data).put(dataKey, dataVal);
            return this;
        }

        @Override
        protected JsonBodyWrapper<?> jsonBodyWrapper() {
            return this.jsonBodyWrapper;
        }
    }

    public static class DataOfData
    extends Data {
        protected final JsonBodyWrapper<Object> jsonBodyWrapper;

        public DataOfData(String message, Object object) {
            this.jsonBodyWrapper = new JsonBodyWrapper<Object>(message, object);
        }

        @Override
        protected JsonBodyWrapper<?> jsonBodyWrapper() {
            return this.jsonBodyWrapper;
        }
    }

    record JsonBodyWrapper<T>(String message, T data) {
    }
}

