/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.WebSocketRoute;
import io.vertx.core.http.ServerWebSocket;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnExceptionRoutingContext {
    private static final Logger logger = LoggerFactory.getLogger(OnExceptionRoutingContext.class);
    private final Throwable throwable;
    private final ServerWebSocket socket;
    private final Iterator<WebSocketRoute> iter;

    OnExceptionRoutingContext(Throwable e, ServerWebSocket serverWebSocket, List<WebSocketRoute> scxWebSocketRoutes) {
        this.throwable = e;
        this.socket = serverWebSocket;
        this.iter = scxWebSocketRoutes.iterator();
    }

    public void next() {
        while (this.iter.hasNext()) {
            WebSocketRoute next = this.iter.next();
            if (!next.matches(this.socket)) continue;
            try {
                next.baseWebSocketHandler().onError(this.throwable, this.socket, this);
            }
            catch (Exception e) {
                logger.error("ScxWebSocketRoute : onError \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
            }
            return;
        }
    }
}

