/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.WebSocketRoute;
import io.vertx.core.http.ServerWebSocket;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnOpenRoutingContext {
    private static final Logger logger = LoggerFactory.getLogger(OnOpenRoutingContext.class);
    private final ServerWebSocket socket;
    private final Iterator<WebSocketRoute> iter;

    OnOpenRoutingContext(ServerWebSocket socket, List<WebSocketRoute> routes) {
        this.socket = socket;
        this.iter = routes.iterator();
    }

    public void next() {
        while (this.iter.hasNext()) {
            WebSocketRoute next = this.iter.next();
            if (!next.matches(this.socket)) continue;
            try {
                next.baseWebSocketHandler().onOpen(this.socket, this);
            }
            catch (Exception e) {
                logger.error("ScxWebSocketRoute : onOpen \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
            }
            return;
        }
    }
}

