/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.mvc.annotation.ScxWebSocketRoute;
import cool.scx.mvc.base.BaseWebSocketHandler;
import cool.scx.mvc.websocket.WebSocketRoute;
import cool.scx.mvc.websocket.WebSocketRouter;
import cool.scx.util.URIBuilder;
import cool.scx.util.reflect.ClassUtils;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;

public final class ScxWebSocketRouteRegistrar {
    private static final Comparator<WebSocketRoute> orderComparator = Comparator.comparing(WebSocketRoute::order);
    private final List<WebSocketRoute> routes;

    public ScxWebSocketRouteRegistrar(BeanFactory beanFactory, List<Class<?>> classList) {
        this.routes = ScxWebSocketRouteRegistrar.initScxWebSocketRoutes(beanFactory, classList);
    }

    private static List<WebSocketRoute> initScxWebSocketRoutes(BeanFactory beanFactory, List<Class<?>> classList) {
        List<? extends Class<? extends BaseWebSocketHandler>> filteredClassList = ScxWebSocketRouteRegistrar.filterClass(classList);
        List<WebSocketRoute> routeList = filteredClassList.stream().map(c -> ScxWebSocketRouteRegistrar.createScxWebSocketRoute(beanFactory, c)).toList();
        return ScxWebSocketRouteRegistrar.sortedScxWebSocketRoutes(routeList);
    }

    public static WebSocketRoute createScxWebSocketRoute(BeanFactory beanFactory, Class<? extends BaseWebSocketHandler> c) {
        ScxWebSocketRoute scxWebSocketMapping = c.getAnnotation(ScxWebSocketRoute.class);
        String path = URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{scxWebSocketMapping.value()}));
        int order = scxWebSocketMapping.order();
        BaseWebSocketHandler baseWebSocketHandler = (BaseWebSocketHandler)beanFactory.getBean(c);
        return new WebSocketRoute(order, path, baseWebSocketHandler);
    }

    public static List<? extends Class<? extends BaseWebSocketHandler>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(ScxWebSocketRouteRegistrar::isScxWebSocketRouteClass).map(c -> c).toList();
    }

    public static boolean isScxWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketRoute.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<WebSocketRoute> sortedScxWebSocketRoutes(List<WebSocketRoute> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public WebSocketRouter registerRoute(WebSocketRouter scxWebSocketRouter) {
        for (WebSocketRoute route : this.routes) {
            scxWebSocketRouter.addRoute(route);
        }
        return scxWebSocketRouter;
    }
}

