/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.WebSocketRoute;
import io.vertx.core.http.ServerWebSocket;
import java.util.Iterator;
import java.util.List;

public class OnCloseRoutingContext {
    private static final System.Logger logger = System.getLogger(OnCloseRoutingContext.class.getName());
    private final ServerWebSocket socket;
    private final Iterator<WebSocketRoute> iter;

    OnCloseRoutingContext(ServerWebSocket serverWebSocket, List<WebSocketRoute> scxWebSocketRoutes) {
        this.socket = serverWebSocket;
        this.iter = scxWebSocketRoutes.iterator();
    }

    public void next() {
        while (this.iter.hasNext()) {
            WebSocketRoute next = this.iter.next();
            if (!next.matches(this.socket)) continue;
            try {
                next.baseWebSocketHandler().onClose(this.socket, this);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "ScxWebSocketRoute : onClose \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
            }
            return;
        }
    }
}

