/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.WebSocketRoute;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.Iterator;
import java.util.List;

public class OnFrameRoutingContext {
    private static final System.Logger logger = System.getLogger(OnFrameRoutingContext.class.getName());
    private final WebSocketFrame socketFrame;
    private final ServerWebSocket socket;
    private final Iterator<WebSocketRoute> iter;

    OnFrameRoutingContext(WebSocketFrame socketFrame, ServerWebSocket socket, List<WebSocketRoute> routes) {
        this.socketFrame = socketFrame;
        this.socket = socket;
        this.iter = routes.iterator();
    }

    public void next() {
        while (this.iter.hasNext()) {
            WebSocketRoute next = this.iter.next();
            if (!next.matches(this.socket)) continue;
            if (this.socketFrame.isText()) {
                try {
                    next.baseWebSocketHandler().onTextMessage(this.socketFrame.textData(), this.socketFrame, this.socket, this);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "ScxWebSocketRoute : onTextMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
                }
            } else if (this.socketFrame.isBinary()) {
                try {
                    next.baseWebSocketHandler().onBinaryMessage(this.socketFrame.binaryData(), this.socketFrame, this.socket, this);
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "ScxWebSocketRoute : onBinaryMessage \u53d1\u751f\u5f02\u5e38 !!!", (Throwable)e);
                }
            }
            return;
        }
    }
}

