/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.enumeration.HttpResponseStatus;
import cool.scx.mvc.ScxHttpRouterExceptionHandler;
import cool.scx.mvc.ScxMvcInterceptor;
import cool.scx.mvc.ScxMvcOptions;
import cool.scx.mvc.ScxMvcParameterHandler;
import cool.scx.mvc.ScxMvcRequestInfo;
import cool.scx.mvc.ScxMvcReturnValueHandler;
import cool.scx.mvc.ScxRouteRegistrar;
import cool.scx.mvc.ScxTemplateHandler;
import cool.scx.mvc.ScxWebSocketRouteRegistrar;
import cool.scx.mvc.exception.BadRequestException;
import cool.scx.mvc.exception.InternalServerErrorException;
import cool.scx.mvc.exception.ScxHttpException;
import cool.scx.mvc.exception_handler.LastExceptionHandler;
import cool.scx.mvc.exception_handler.ScxHttpExceptionHandler;
import cool.scx.mvc.interceptor.DefaultInterceptorImpl;
import cool.scx.mvc.parameter_handler.FromBodyParameterHandler;
import cool.scx.mvc.parameter_handler.FromPathParameterHandler;
import cool.scx.mvc.parameter_handler.FromQueryParameterHandler;
import cool.scx.mvc.parameter_handler.LastParameterHandler;
import cool.scx.mvc.parameter_handler.RoutingContextParameterHandler;
import cool.scx.mvc.parameter_handler.UploadedEntityParameterHandler;
import cool.scx.mvc.parameter_handler.exception.ParamConvertException;
import cool.scx.mvc.parameter_handler.exception.RequiredParamEmptyException;
import cool.scx.mvc.return_value_handler.BaseVoReturnValueHandler;
import cool.scx.mvc.return_value_handler.HtmlVoReturnValueHandler;
import cool.scx.mvc.return_value_handler.LastReturnValueHandler;
import cool.scx.mvc.return_value_handler.NullReturnValueHandler;
import cool.scx.mvc.return_value_handler.StringReturnValueHandler;
import cool.scx.mvc.websocket.WebSocketRouter;
import cool.scx.util.ScxExceptionHelper;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;

public final class ScxMvc {
    private static final InheritableThreadLocal<RoutingContext> ROUTING_CONTEXT_THREAD_LOCAL = new InheritableThreadLocal();
    private final List<ScxHttpRouterExceptionHandler> exceptionHandlers = new ArrayList<ScxHttpRouterExceptionHandler>();
    private final LastExceptionHandler lastExceptionHandler;
    private final List<ScxMvcReturnValueHandler> returnValueHandlers = new ArrayList<ScxMvcReturnValueHandler>();
    private final LastReturnValueHandler lastReturnValueHandler;
    private final List<ScxMvcParameterHandler> parameterHandlers = new ArrayList<ScxMvcParameterHandler>();
    private final LastParameterHandler lastParameterHandler;
    private final ScxTemplateHandler templateHandler;
    private ScxMvcInterceptor interceptor = new DefaultInterceptorImpl();

    public ScxMvc() {
        this(new ScxMvcOptions());
    }

    public ScxMvc(ScxMvcOptions options) {
        this.templateHandler = new ScxTemplateHandler(options.templateRoot());
        this.addExceptionHandler(new ScxHttpExceptionHandler(options.useDevelopmentErrorPage()));
        this.lastExceptionHandler = new LastExceptionHandler(options.useDevelopmentErrorPage());
        this.addReturnValueHandler(new NullReturnValueHandler());
        this.addReturnValueHandler(new StringReturnValueHandler());
        this.addReturnValueHandler(new HtmlVoReturnValueHandler(this.templateHandler));
        this.addReturnValueHandler(new BaseVoReturnValueHandler());
        this.lastReturnValueHandler = new LastReturnValueHandler();
        this.addParameterHandler(new RoutingContextParameterHandler());
        this.addParameterHandler(new UploadedEntityParameterHandler());
        this.addParameterHandler(new FromBodyParameterHandler());
        this.addParameterHandler(new FromQueryParameterHandler());
        this.addParameterHandler(new FromPathParameterHandler());
        this.lastParameterHandler = new LastParameterHandler();
    }

    public static RoutingContext routingContext() {
        return (RoutingContext)ROUTING_CONTEXT_THREAD_LOCAL.get();
    }

    static void _routingContext(RoutingContext routingContext) {
        ROUTING_CONTEXT_THREAD_LOCAL.set(routingContext);
    }

    static void _clearRoutingContext() {
        ROUTING_CONTEXT_THREAD_LOCAL.remove();
    }

    public ScxMvc registerHttpRoutes(Router router, BeanFactory beanFactory, List<Class<?>> classList) {
        new ScxRouteRegistrar(this, beanFactory, classList).registerRoute(router);
        return this;
    }

    public ScxMvc registerWebSocketRoutes(WebSocketRouter router, BeanFactory beanFactory, List<Class<?>> classList) {
        new ScxWebSocketRouteRegistrar(beanFactory, classList).registerRoute(router);
        return this;
    }

    public ScxMvc setInterceptor(ScxMvcInterceptor newInterceptor) {
        if (newInterceptor == null) {
            throw new IllegalArgumentException("ScxMvcInterceptor must not be empty !!!");
        }
        this.interceptor = newInterceptor;
        return this;
    }

    public ScxMvc addExceptionHandler(ScxHttpRouterExceptionHandler scxHttpRouterExceptionHandler) {
        this.exceptionHandlers.add(scxHttpRouterExceptionHandler);
        return this;
    }

    public ScxMvc addParameterHandler(ScxMvcParameterHandler handler) {
        this.parameterHandlers.add(handler);
        return this;
    }

    public ScxMvc addReturnValueHandler(ScxMvcReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(returnValueHandler);
        return this;
    }

    public ScxMvc addExceptionHandler(int index, ScxHttpRouterExceptionHandler handler) {
        this.exceptionHandlers.add(index, handler);
        return this;
    }

    public ScxMvc addParameterHandler(int index, ScxMvcParameterHandler handler) {
        this.parameterHandlers.add(index, handler);
        return this;
    }

    public ScxMvc addReturnValueHandler(int index, ScxMvcReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(index, returnValueHandler);
        return this;
    }

    ScxMvcInterceptor interceptor() {
        return this.interceptor;
    }

    public ScxTemplateHandler templateHandler() {
        return this.templateHandler;
    }

    public ScxHttpRouterExceptionHandler findExceptionHandler(Throwable throwable) {
        for (ScxHttpRouterExceptionHandler handler : this.exceptionHandlers) {
            if (!handler.canHandle(throwable)) continue;
            return handler;
        }
        return this.lastExceptionHandler;
    }

    ScxMvcReturnValueHandler findReturnValueHandler(Object result) {
        for (ScxMvcReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.canHandle(result)) continue;
            return handler;
        }
        return this.lastReturnValueHandler;
    }

    ScxMvcParameterHandler findParameterHandler(Parameter parameter) {
        for (ScxMvcParameterHandler handler : this.parameterHandlers) {
            if (!handler.canHandle(parameter)) continue;
            return handler;
        }
        return this.lastParameterHandler;
    }

    Object[] buildMethodParameters(Parameter[] parameters, RoutingContext context) throws Exception {
        ScxMvcRequestInfo info = new ScxMvcRequestInfo(context);
        ArrayList<Exception> exceptionArrayList = new ArrayList<Exception>();
        Object[] methodParameter = new Object[parameters.length];
        for (int i = 0; i < methodParameter.length; ++i) {
            ScxMvcParameterHandler methodParameterHandler = this.findParameterHandler(parameters[i]);
            try {
                methodParameter[i] = methodParameterHandler.handle(parameters[i], info);
                continue;
            }
            catch (ParamConvertException | RequiredParamEmptyException e) {
                exceptionArrayList.add(e);
            }
        }
        if (!exceptionArrayList.isEmpty()) {
            throw new BadRequestException(exceptionArrayList.stream().map(Throwable::getMessage).collect(Collectors.joining(";" + System.lineSeparator())));
        }
        return methodParameter;
    }

    public ScxMvc bindErrorHandler(Router vertxRouter) {
        ErrorHandler errorHandler = new ErrorHandler(this);
        for (HttpResponseStatus s : HttpResponseStatus.values()) {
            if (s.statusCode() < 400) continue;
            vertxRouter.errorHandler(s.statusCode(), (Handler)errorHandler);
        }
        return this;
    }

    private record ErrorHandler(ScxMvc scxMvc) implements Handler<RoutingContext>
    {
        public void handle(RoutingContext routingContext) {
            Throwable cause = ScxExceptionHelper.getRootCause((Throwable)routingContext.failure());
            int statusCode = routingContext.statusCode();
            if (statusCode == 500) {
                this.scxMvc.findExceptionHandler(cause).handle(cause, routingContext);
            } else {
                HttpResponseStatus status = HttpResponseStatus.of((int)statusCode);
                ScxHttpException scxHttpException = status != null ? new ScxHttpException(status.statusCode(), status.reasonPhrase(), cause) : new InternalServerErrorException(cause);
                this.scxMvc.findExceptionHandler(scxHttpException).handle(scxHttpException, routingContext);
            }
        }
    }
}

