/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.enumeration.HttpMethod;
import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.ScxMvcHelper;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.util.CaseUtils;
import cool.scx.util.ScxExceptionHelper;
import cool.scx.util.URIBuilder;
import io.vertx.core.Handler;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class ScxRouteHandler
implements Handler<RoutingContext> {
    public final Method method;
    public final boolean isVoid;
    public final Parameter[] parameters;
    public final Object instance;
    public final Class<?> clazz;
    public final String originalUrl;
    public final HttpMethod[] httpMethods;
    public final String[] consumes;
    public final String[] produces;
    private final ScxMvc scxMvc;
    private final int order;
    private RouteState routeState;

    ScxRouteHandler(Method method, Object instance, ScxMvc scxMvc) {
        this.scxMvc = scxMvc;
        this.clazz = instance.getClass();
        this.method = method;
        this.method.setAccessible(true);
        this.isVoid = method.getReturnType().equals(Void.TYPE);
        this.parameters = method.getParameters();
        this.instance = instance;
        ScxRoute clazzAnnotation = this.clazz.getAnnotation(ScxRoute.class);
        ScxRoute methodAnnotation = method.getAnnotation(ScxRoute.class);
        this.originalUrl = this.initOriginalUrl(clazzAnnotation, methodAnnotation);
        this.consumes = ScxRouteHandler.distinct(methodAnnotation.consumes());
        this.produces = ScxRouteHandler.distinct(methodAnnotation.produces());
        this.httpMethods = ScxRouteHandler.distinct(methodAnnotation.methods());
        this.order = methodAnnotation.order();
    }

    private static HttpMethod[] distinct(HttpMethod[] methods) {
        return (HttpMethod[])Arrays.stream(methods).distinct().toArray(HttpMethod[]::new);
    }

    private static String[] distinct(String[] strings) {
        return (String[])Arrays.stream(strings).distinct().toArray(String[]::new);
    }

    private String initOriginalUrl(ScxRoute classAnnotation, ScxRoute methodAnnotation) {
        String[] urlArray = new String[]{"", ""};
        if (classAnnotation != null && !classAnnotation.ignoreParentUrl()) {
            urlArray[0] = classAnnotation.value();
        }
        urlArray[1] = methodAnnotation.useNameAsUrl() && "".equals(methodAnnotation.value()) ? CaseUtils.toKebab((String)this.method.getName()) : methodAnnotation.value();
        return URIBuilder.addSlashStart((String)URIBuilder.join((String[])urlArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RoutingContext context) {
        ScxMvc._routingContext(context);
        try {
            this.scxMvc.interceptor().preHandle(context, this);
            Object[] methodParameters = this.scxMvc.buildMethodParameters(this.parameters, context);
            Object tempResult = this.method.invoke(this.instance, methodParameters);
            Object finalResult = this.scxMvc.interceptor().postHandle(context, this, tempResult);
            if (!this.isVoid && ScxMvcHelper.responseCanUse(context)) {
                this.scxMvc.findReturnValueHandler(finalResult).handle(finalResult, context);
            }
        }
        catch (Throwable e) {
            Throwable exception = ScxExceptionHelper.getRootCause((Throwable)(e instanceof InvocationTargetException ? e.getCause() : e));
            this.scxMvc.findExceptionHandler(exception).handle(exception, context);
        }
        finally {
            ScxMvc._clearRoutingContext();
        }
    }

    void setRouteState(RouteState route) {
        this.routeState = route;
    }

    RouteState routeState() {
        return this.routeState;
    }

    public int order() {
        return this.order;
    }

    record RouteState(Map<String, Object> metadata, String path, String name, int order, boolean enabled, Set<HttpMethod> methods, Set<MIMEHeader> consumes, boolean emptyBodyPermittedWithConsumes, Set<MIMEHeader> produces, boolean added, Pattern pattern, List<String> groups, boolean useNormalizedPath, Set<String> namedGroupsInRegex, Pattern virtualHostPattern, boolean pathEndsWithSlash, boolean exclusive, boolean exactPath) {
        int getGroupsOrder() {
            return this.groups == null ? 0 : this.groups.size();
        }

        int getExactPathOrder() {
            return this.exactPath ? 0 : 1;
        }
    }
}

