/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.base.BaseWebSocketHandler;
import io.vertx.core.http.ServerWebSocket;
import java.util.regex.Pattern;

public final class WebSocketRoute {
    private static final System.Logger logger = System.getLogger(WebSocketRoute.class.getName());
    private final String path;
    private final Pattern pattern;
    private final BaseWebSocketHandler baseWebSocketHandler;
    private final int order;

    public WebSocketRoute(String path, BaseWebSocketHandler baseWebSocketHandler) {
        this(0, path, baseWebSocketHandler);
    }

    public WebSocketRoute(int order, String path, BaseWebSocketHandler baseWebSocketHandler) {
        this.order = order;
        this.path = path;
        this.pattern = Pattern.compile(path);
        this.baseWebSocketHandler = baseWebSocketHandler;
    }

    public boolean matches(ServerWebSocket serverWebSocket) {
        return this.pattern.matcher(serverWebSocket.path()).matches();
    }

    public String path() {
        return this.path;
    }

    public BaseWebSocketHandler baseWebSocketHandler() {
        return this.baseWebSocketHandler;
    }

    public int order() {
        return this.order;
    }
}

