package cool.scx.mvc.annotation;

import cool.scx.enumeration.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 路由注解 默认会在方法上进行继承 如果想在子类禁用 请使用 NoScxRoute
 *
 * @author scx567888
 * @version 0.3.6
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ScxRoute {

    /**
     * @return the path
     * @see Router#route(String)
     */
    String value() default "";

//    /** todo 待支持
//     * @return the path
//     * @see Router#routeWithRegex(String)
//     */
//    String regex() default "";

    /**
     * @return the path
     * @see Route#method(io.vertx.core.http.HttpMethod) (String)
     */
    HttpMethod[] methods() default {};

    /**
     * @return the path
     * @see Route#consumes(String)
     */
    String[] consumes() default {};

    /**
     * @return the path
     * @see Route#produces(String)
     */
    String[] produces() default {};

    /**
     * 排序
     *
     * @return a
     */
    int order() default 0;

    /**
     * 是否忽略类级别上的 ScxRoute 注解所定义的顶级 url
     *
     * @return 是否
     */
    boolean ignoreParentUrl() default false;

    /**
     * 注意 : 仅当作用于方法时生效 !!!
     * 是否使用方法名称作为 url 路径 <br>
     * 仅当 value 为 "" 时生效 <br>
     * 规则为 获取方法名称 然后转换为 短横线命名法 <br>
     * 如 方法名为  getUserList 则 url 为 /user/get-user-list
     *
     * @return 标识
     */
    boolean useNameAsUrl() default true;

}
