/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.websocket;

import cool.scx.mvc.websocket.OnCloseRoutingContext;
import cool.scx.mvc.websocket.OnExceptionRoutingContext;
import cool.scx.mvc.websocket.OnFrameRoutingContext;
import cool.scx.mvc.websocket.OnOpenRoutingContext;
import cool.scx.mvc.websocket.WebSocketRoute;
import io.vertx.core.Handler;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.ArrayList;
import java.util.List;

public final class WebSocketRouter
implements Handler<ServerWebSocket> {
    private static final System.Logger logger = System.getLogger(WebSocketRouter.class.getName());
    private final List<WebSocketRoute> routes = new ArrayList<WebSocketRoute>();

    public WebSocketRouter addRoute(WebSocketRoute scxRoute) {
        this.routes.add(scxRoute);
        return this;
    }

    public List<WebSocketRoute> getRoutes() {
        return new ArrayList<WebSocketRoute>(this.routes);
    }

    public void handle(ServerWebSocket serverWebSocket) {
        if (this.anyMatch(serverWebSocket)) {
            serverWebSocket.frameHandler(h -> new OnFrameRoutingContext((WebSocketFrame)h, serverWebSocket, this.routes).next()).exceptionHandler(e -> new OnExceptionRoutingContext((Throwable)e, serverWebSocket, this.routes).next()).closeHandler(v -> new OnCloseRoutingContext(serverWebSocket, this.routes).next());
            new OnOpenRoutingContext(serverWebSocket, this.routes).next();
        }
    }

    private boolean anyMatch(ServerWebSocket serverWebSocket) {
        boolean anyMatch = this.routes.stream().anyMatch((? super T c) -> c.matches(serverWebSocket));
        if (!anyMatch) {
            serverWebSocket.reject(404);
        }
        return anyMatch;
    }
}

