/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.ScxRouteHandler;
import cool.scx.mvc.annotation.NoScxRoute;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.standard.HttpMethod;
import cool.scx.util.MultiMap;
import cool.scx.util.ObjectUtils;
import cool.scx.util.reflect.ClassUtils;
import cool.scx.util.reflect.MethodUtils;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.impl.RouteImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;

public final class ScxRouteRegistrar {
    private static final System.Logger logger = System.getLogger(ScxRouteRegistrar.class.getName());
    private static final Method vertxRouteStateMethod = ScxRouteRegistrar.initVertxRouteStateMethod();
    private static final Comparator<ScxRouteHandler> exactPathComparator = Comparator.comparing(routeState -> routeState.routeState().getExactPathOrder());
    private static final Comparator<ScxRouteHandler> groupsComparator = Comparator.comparing(routeState -> routeState.routeState().getGroupsOrder());
    private static final Comparator<ScxRouteHandler> orderComparator = Comparator.comparing(ScxRouteHandler::order);
    private static final Pattern RE_TOKEN_SEARCH = Pattern.compile(":(\\w+)");
    private final List<ScxRouteHandler> scxRouteHandlers;

    public ScxRouteRegistrar(ScxMvc scxMvc, Object ... objects) {
        this.scxRouteHandlers = ScxRouteRegistrar.initScxRouteHandlers(scxMvc, objects);
    }

    private static List<ScxRouteHandler> initScxRouteHandlers(ScxMvc scxMvc, Object ... objects) {
        List<Object> filteredObjectList = ScxRouteRegistrar.filterObject(objects);
        ArrayList<ScxRouteHandler> handlers = new ArrayList<ScxRouteHandler>();
        for (Object c : filteredObjectList) {
            List<Method> methods = ScxRouteRegistrar.filterMethod(c);
            for (Method m : methods) {
                handlers.add(ScxRouteRegistrar.createScxRouteHandler(m, c, scxMvc));
            }
        }
        return ScxRouteRegistrar.sortedScxRouteHandlers(handlers);
    }

    private static Method initVertxRouteStateMethod() {
        try {
            Method m = RouteImpl.class.getDeclaredMethod("state", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static ScxRouteHandler.RouteState getRouteState(Route r) {
        try {
            return (ScxRouteHandler.RouteState)ObjectUtils.convertValue((Object)vertxRouteStateMethod.invoke((Object)r, new Object[0]), ScxRouteHandler.RouteState.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ScxRouteHandler> sortedScxRouteHandlers(List<ScxRouteHandler> handlers) {
        List<ScxRouteHandler> list = ScxRouteRegistrar.fillRouteState(handlers);
        return list.stream().sorted(orderComparator.thenComparing(exactPathComparator).thenComparing(groupsComparator)).toList();
    }

    private static List<ScxRouteHandler> fillRouteState(List<ScxRouteHandler> list) {
        Router tempRouter = Router.router(null);
        return list.stream().peek(c -> c.setRouteState(ScxRouteRegistrar.getRouteState(tempRouter.route(c.originalUrl)))).toList();
    }

    private static ScxRouteHandler createScxRouteHandler(Method m, Object bean, ScxMvc scxMvc) {
        return new ScxRouteHandler(m, bean, scxMvc);
    }

    private static List<Object> filterObject(Object ... objects) {
        return Arrays.stream(objects).filter(o -> ScxRouteRegistrar.isRoute(o.getClass())).toList();
    }

    public static List<Class<?>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(ScxRouteRegistrar::isRoute).toList();
    }

    private static List<Method> filterMethod(Object object) {
        return Arrays.stream(MethodUtils.findMethods(object.getClass())).filter(ScxRouteRegistrar::isRoute).toList();
    }

    public static boolean isRoute(Class<?> c) {
        return (c.isAnnotationPresent(ScxRoute.class) || c.isAnnotationPresent(Controller.class)) && ClassUtils.isNormalClass(c);
    }

    public static boolean isRoute(Method m) {
        if (m.isBridge()) {
            return false;
        }
        NoScxRoute noScxRoute = m.getAnnotation(NoScxRoute.class);
        if (noScxRoute != null) {
            return false;
        }
        ScxRoute s = ScxRouteRegistrar.findScxRoute(m);
        return s != null;
    }

    public static ScxRoute findScxRoute(Method method) {
        Annotation[] annotations;
        for (Annotation a : annotations = MethodUtils.findAllAnnotations((Method)method)) {
            if (!(a instanceof ScxRoute)) continue;
            ScxRoute s = (ScxRoute)a;
            return s;
        }
        return null;
    }

    public static ScxRoute findScxRouteOrThrow(Method method) {
        ScxRoute scxRoute = ScxRouteRegistrar.findScxRoute(method);
        if (scxRoute == null) {
            throw new NullPointerException();
        }
        return scxRoute;
    }

    private static void checkRouteExists(List<ScxRouteHandler> handlers) {
        MultiMap m = new MultiMap();
        for (ScxRouteHandler handler : handlers) {
            String key;
            String string = key = handler.routeState().pattern() != null ? handler.routeState().pattern().toString() : handler.routeState().path();
            if (handler.httpMethods.length == 0) {
                m.put((Object)new NormalPathInfo("*", key), (Object)handler);
                continue;
            }
            for (HttpMethod httpMethod : handler.httpMethods) {
                m.put((Object)new NormalPathInfo(httpMethod.name(), key), (Object)handler);
            }
        }
        Map map = m.toMultiValueMap();
        map.forEach((k, v) -> {
            if (v.size() > 1) {
                String content = v.stream().map(c -> "\t" + c.clazz.getName() + " : " + c.method.getName()).collect(Collectors.joining(System.lineSeparator()));
                logger.log(System.Logger.Level.WARNING, "\u68c0\u6d4b\u5230\u91cd\u590d\u7684\u8def\u7531!!! {0} --> \"{1}\" , \u76f8\u5173 class \u53ca \u65b9\u6cd5 \u5982\u4e0b \u25bc" + System.lineSeparator() + "{2}", k.httpMethod(), ScxRouteRegistrar.getPatternUrl(((ScxRouteHandler)v.get((int)0)).originalUrl), content);
            }
        });
    }

    private static String getPatternUrl(String path) {
        return RE_TOKEN_SEARCH.matcher(path).replaceAll("?");
    }

    public List<ScxRouteHandler> scxRouteHandlers() {
        return new ArrayList<ScxRouteHandler>(this.scxRouteHandlers);
    }

    public Router registerRoute(Router router) {
        ScxRouteRegistrar.checkRouteExists(this.scxRouteHandlers);
        for (ScxRouteHandler c : this.scxRouteHandlers) {
            Route r = router.route(c.originalUrl);
            for (HttpMethod httpMethod : c.httpMethods) {
                r.method(httpMethod.vertxMethod());
            }
            for (String string : c.consumes) {
                r.consumes(string);
            }
            for (String string : c.produces) {
                r.produces(string);
            }
            r.handler((Handler)c);
        }
        return router;
    }

    private record NormalPathInfo(String httpMethod, String key) {
    }
}

