/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.standard.HttpHeader;
import cool.scx.standard.MediaType;
import cool.scx.util.ObjectUtils;
import io.vertx.ext.web.RoutingContext;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Result
implements BaseVo {
    public static ResultOfMap ok() {
        return new ResultOfMap("ok");
    }

    public static ResultOfData ok(Object object) {
        return new ResultOfData("ok", object);
    }

    public static ResultOfMap fail() {
        return new ResultOfMap("fail");
    }

    public static ResultOfMap fail(String failMessage) {
        return new ResultOfMap(failMessage);
    }

    public static ResultOfData fail(String failMessage, Object object) {
        return new ResultOfData(failMessage, object);
    }

    public static ResultOfMap of(String message) {
        return new ResultOfMap(message);
    }

    public static ResultOfData of(String message, Object object) {
        return new ResultOfData(message, object);
    }

    public void accept(RoutingContext context) {
        String accept = context.request().getHeader(HttpHeader.ACCEPT.toString());
        if (accept != null && accept.toLowerCase().startsWith(MediaType.APPLICATION_XML.toString())) {
            BaseVo.fillXmlContentType(context.request().response()).end(this.toXml(""));
        } else {
            BaseVo.fillJsonContentType(context.request().response()).end(this.toJson(""));
        }
    }

    public abstract Body<?> body();

    public String toJson() throws JsonProcessingException {
        return ObjectUtils.toJson(this.body(), (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String toXml() throws JsonProcessingException {
        return ObjectUtils.toXml(this.body(), (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String toJson(String defaultValue) {
        return ObjectUtils.toJson(this.body(), (String)defaultValue, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String toXml(String defaultValue) {
        return ObjectUtils.toJson(this.body(), (String)defaultValue, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public static class ResultOfMap
    extends Result {
        protected final Body<Map<String, Object>> body;

        private ResultOfMap(String message) {
            this.body = new Body(message, new LinkedHashMap());
        }

        public ResultOfMap put(String dataKey, Object dataVal) {
            ((Map)this.body.data).put(dataKey, dataVal);
            return this;
        }

        public ResultOfMap remove(String dataKey, Object dataVal) {
            ((Map)this.body.data).remove(dataKey, dataVal);
            return this;
        }

        @Override
        public Body<?> body() {
            return this.body;
        }
    }

    public static class ResultOfData
    extends Result {
        protected final Body<Object> body;

        public ResultOfData(String message, Object object) {
            this.body = new Body<Object>(message, object);
        }

        @Override
        public Body<?> body() {
            return this.body;
        }
    }

    public record Body<T>(String message, T data) {
    }
}

