/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import cool.scx.mvc.exception.BadRequestException;
import cool.scx.mvc.exception.NotFoundException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.standard.HttpHeader;
import cool.scx.standard.MediaType;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.AbsoluteSize;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Size;

public abstract class Image
implements BaseVo {
    protected Image(File _file) {
        Objects.requireNonNull(_file, "\u56fe\u7247\u6587\u4ef6\u4e0d\u80fd\u4e3a null");
        if (!_file.exists()) {
            throw new NotFoundException();
        }
    }

    public static Image of(File file) {
        return Image.of(file, null, null, null);
    }

    public static Image of(File file, Integer width, Integer height, Position position) {
        String contentType = MimeMapping.getMimeTypeForFilename((String)file.getName());
        if (contentType != null && contentType.startsWith("image")) {
            if (height == null && width == null) {
                return new OriginalImage(file);
            }
            return new CroppedImage(file, width, height, position);
        }
        return new SystemIconImage(file);
    }

    public final void accept(RoutingContext context) throws BadRequestException {
        context.response().putHeader(HttpHeader.CACHE_CONTROL.toString(), "public,immutable,max-age=2628000").putHeader(HttpHeader.ACCEPT_RANGES.toString(), "bytes");
        this.imageHandler(context);
    }

    public abstract void imageHandler(RoutingContext var1);

    private static final class OriginalImage
    extends Image {
        private final String filePath;

        public OriginalImage(File file) {
            super(file);
            this.filePath = file.getPath();
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().sendFile(this.filePath);
        }
    }

    private static final class CroppedImage
    extends Image {
        private final String contentType;
        private final Buffer buffer;

        public CroppedImage(File file, Integer width, Integer height, Position position) {
            super(file);
            this.contentType = MimeMapping.getMimeTypeForFilename((String)file.getName());
            this.buffer = this.getBuffer(file, width, height, position);
        }

        private Buffer getBuffer(File file, Integer width, Integer height, Position position) {
            Buffer buffer;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                BufferedImage image = Thumbnails.of((File[])new File[]{file}).scale(1.0).asBufferedImage();
                int imageHeight = image.getHeight();
                int imageWidth = image.getWidth();
                int croppedHeight = height == null || height > imageHeight || height <= 0 ? imageHeight : height;
                int croppedWidth = width == null || width > imageHeight || width <= 0 ? imageWidth : width;
                AbsoluteSize absoluteSize = new AbsoluteSize(croppedWidth, croppedHeight);
                if (position != null) {
                    Thumbnails.of((File[])new File[]{file}).sourceRegion(position, (Size)absoluteSize).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                } else {
                    Thumbnails.of((File[])new File[]{file}).size(croppedWidth, croppedHeight).keepAspectRatio(false).toOutputStream((OutputStream)out);
                }
                buffer = Buffer.buffer((byte[])out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException(e);
                }
            }
            out.close();
            return buffer;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().putHeader(HttpHeader.CONTENT_TYPE.toString(), this.contentType).end(this.buffer);
        }
    }

    private static final class SystemIconImage
    extends Image {
        private final Buffer buffer;

        public SystemIconImage(File file) {
            super(file);
            this.buffer = this.getBuffer(file);
        }

        private Buffer getBuffer(File file) {
            Buffer buffer;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                java.awt.Image image = ((ImageIcon)FileSystemView.getFileSystemView().getSystemIcon(file)).getImage();
                BufferedImage myImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D g = myImage.createGraphics();
                g.drawImage(image, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)myImage, "png", out);
                buffer = Buffer.buffer((byte[])out.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BadRequestException(e);
                }
            }
            out.close();
            return buffer;
        }

        @Override
        public void imageHandler(RoutingContext context) {
            context.response().putHeader(HttpHeader.CONTENT_TYPE.toString(), MediaType.IMAGE_PNG.toString()).end(this.buffer);
        }
    }
}

