/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc;

import cool.scx.common.util.URIBuilder;
import cool.scx.common.util.reflect.ClassUtils;
import cool.scx.mvc.annotation.ScxWebSocketRoute;
import cool.scx.mvc.base.BaseWebSocketHandler;
import cool.scx.mvc.websocket.WebSocketRoute;
import cool.scx.mvc.websocket.WebSocketRouter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class ScxWebSocketRouteRegistrar {
    private static final Comparator<WebSocketRoute> orderComparator = Comparator.comparing(WebSocketRoute::order);
    private final List<WebSocketRoute> routes;

    public ScxWebSocketRouteRegistrar(Object ... objects) {
        this.routes = ScxWebSocketRouteRegistrar.initScxWebSocketRoutes(objects);
    }

    private static List<WebSocketRoute> initScxWebSocketRoutes(Object ... objects) {
        List<BaseWebSocketHandler> filteredObjectList = ScxWebSocketRouteRegistrar.filterObject(objects);
        List<WebSocketRoute> routeList = filteredObjectList.stream().map(ScxWebSocketRouteRegistrar::createScxWebSocketRoute).toList();
        return ScxWebSocketRouteRegistrar.sortedScxWebSocketRoutes(routeList);
    }

    public static WebSocketRoute createScxWebSocketRoute(BaseWebSocketHandler o) {
        Class<?> c = o.getClass();
        ScxWebSocketRoute scxWebSocketMapping = c.getAnnotation(ScxWebSocketRoute.class);
        String path = URIBuilder.addSlashStart((String)URIBuilder.join((String[])new String[]{scxWebSocketMapping.value()}));
        int order = scxWebSocketMapping.order();
        return new WebSocketRoute(order, path, o);
    }

    public static List<BaseWebSocketHandler> filterObject(Object ... classList) {
        return Arrays.stream(classList).filter(o -> ScxWebSocketRouteRegistrar.isScxWebSocketRouteClass(o.getClass())).map(c -> (BaseWebSocketHandler)c).toList();
    }

    public static List<? extends Class<? extends BaseWebSocketHandler>> filterClass(List<Class<?>> classList) {
        return classList.stream().filter(ScxWebSocketRouteRegistrar::isScxWebSocketRouteClass).map(c -> c).toList();
    }

    public static boolean isScxWebSocketRouteClass(Class<?> c) {
        return c.isAnnotationPresent(ScxWebSocketRoute.class) && ClassUtils.isNormalClass(c) && BaseWebSocketHandler.class.isAssignableFrom(c);
    }

    private static List<WebSocketRoute> sortedScxWebSocketRoutes(List<WebSocketRoute> list) {
        return list.stream().sorted(orderComparator).toList();
    }

    public WebSocketRouter registerRoute(WebSocketRouter scxWebSocketRouter) {
        for (WebSocketRoute route : this.routes) {
            scxWebSocketRouter.addRoute(route);
        }
        return scxWebSocketRouter;
    }
}

