/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.type;

import cool.scx.common.util.ScxExceptionHelper;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.FileUpload;
import java.nio.file.Files;
import java.nio.file.Path;

public final class UploadedEntity {
    private final FileUpload vertxFileUpload;

    public UploadedEntity(FileUpload fileUpload) {
        this.vertxFileUpload = fileUpload;
    }

    public String name() {
        return this.vertxFileUpload.name();
    }

    public String fileName() {
        return this.vertxFileUpload.fileName();
    }

    public long size() {
        return this.vertxFileUpload.size();
    }

    public Buffer buffer() {
        return (Buffer)ScxExceptionHelper.wrap(() -> {
            Path target = Path.of(this.vertxFileUpload.uploadedFileName(), new String[0]);
            byte[] bytes = Files.readAllBytes(target);
            return Buffer.buffer((byte[])bytes);
        });
    }

    public String contentType() {
        return this.vertxFileUpload.contentType();
    }

    public String charset() {
        return this.vertxFileUpload.charSet();
    }

    public FileUpload vertxFileUpload() {
        return this.vertxFileUpload;
    }
}

