/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.exception_handler;

import cool.scx.common.standard.HttpHeader;
import cool.scx.common.standard.MediaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.mvc.ScxHttpRouterExceptionHandler;
import cool.scx.mvc.ScxMvcHelper;
import cool.scx.mvc.exception.ScxHttpException;
import cool.scx.mvc.vo.BaseVo;
import io.vertx.ext.web.RoutingContext;
import java.util.LinkedHashMap;

public class ScxHttpExceptionHandler
implements ScxHttpRouterExceptionHandler {
    private static final String htmlTemplate = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>%s</title>\n</head>\n<body>\n    <h1>%s - %s</h1>\n    <hr>\n    <pre>%s</pre>\n</body>\n</html>\n";
    private static final System.Logger logger = System.getLogger(ScxHttpExceptionHandler.class.getName());
    private final boolean useDevelopmentErrorPage;

    public ScxHttpExceptionHandler(boolean useDevelopmentErrorPage) {
        this.useDevelopmentErrorPage = useDevelopmentErrorPage;
    }

    public static void sendToClient(int statusCode, String title, String info, RoutingContext routingContext) {
        String accept;
        if (title == null) {
            title = "";
        }
        if (info == null) {
            info = "";
        }
        if ((accept = routingContext.request().headers().get(HttpHeader.ACCEPT.toString())) != null && accept.toLowerCase().contains(MediaType.TEXT_HTML.toString())) {
            String htmlStr = String.format(htmlTemplate, title, statusCode, title, info);
            BaseVo.fillHtmlContentType(routingContext.request().response().setStatusCode(statusCode)).end(htmlStr);
        } else {
            LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
            tempMap.put("statusCode", statusCode);
            tempMap.put("title", title);
            tempMap.put("info", info);
            String jsonStr = ObjectUtils.toJson(tempMap, (String)"", (ObjectUtils.Option[])new ObjectUtils.Option[0]);
            BaseVo.fillJsonContentType(routingContext.request().response().setStatusCode(statusCode)).end(jsonStr);
        }
    }

    public void handleScxHttpException(ScxHttpException scxHttpException, RoutingContext routingContext) {
        String info = null;
        if (this.useDevelopmentErrorPage) {
            Throwable cause = ScxExceptionHelper.getRootCause((Throwable)scxHttpException.getCause());
            info = cause == null ? scxHttpException.getMessage() : ScxExceptionHelper.getStackTraceString((Throwable)cause);
        }
        ScxHttpExceptionHandler.sendToClient(scxHttpException.statusCode(), scxHttpException.title(), info, routingContext);
    }

    @Override
    public boolean canHandle(Throwable throwable) {
        return throwable instanceof ScxHttpException;
    }

    @Override
    public void handle(Throwable throwable, RoutingContext context) {
        if (ScxMvcHelper.responseCanUse(context)) {
            this.handleScxHttpException((ScxHttpException)throwable, context);
        } else {
            logger.log(System.Logger.Level.ERROR, "\u6355\u83b7\u5230 ScxHttpException \u5f02\u5e38 !!!, \u56e0\u4e3a\u8bf7\u6c42\u5df2\u88ab\u76f8\u5e94, \u6240\u4ee5\u9519\u8bef\u4fe1\u606f\u53ef\u80fd\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7ed9\u5ba2\u6237\u7aef !!!", throwable);
        }
    }
}

