/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.mvc.vo;

import cool.scx.common.standard.HttpHeader;
import cool.scx.common.standard.MediaType;
import cool.scx.common.util.ScxExceptionHelper;
import cool.scx.mvc._hack.SendFileHelper;
import cool.scx.mvc.exception.NotFoundException;
import cool.scx.mvc.vo.BaseVo;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;

class BaseWriter
implements BaseVo {
    private static final int bucketSize = 1024000;
    protected final InputStream inputStream;
    protected final Path path;
    protected final byte[] bytes;
    protected final Type type;
    protected final MediaType contentType;
    protected final String contentDisposition;

    private BaseWriter(InputStream inputStream, Path path, byte[] bytes, Type type, MediaType contentType, String contentDisposition) {
        this.inputStream = inputStream;
        this.path = path;
        this.bytes = bytes;
        this.type = type;
        this.contentType = contentType;
        this.contentDisposition = contentDisposition;
    }

    protected BaseWriter(InputStream inputStream, MediaType contentType, String contentDisposition) {
        this(inputStream, null, null, Type.INPUT_STREAM, contentType, contentDisposition);
    }

    protected BaseWriter(Path path, MediaType contentType, String contentDisposition) {
        this(null, path, null, Type.PATH, contentType, contentDisposition);
    }

    protected BaseWriter(byte[] bytes, MediaType contentType, String contentDisposition) {
        this(null, null, bytes, Type.BYTE_ARRAY, contentType, contentDisposition);
    }

    public final void accept(RoutingContext context) {
        switch (this.type.ordinal()) {
            case 2: {
                this.sendBytes(context);
                break;
            }
            case 0: {
                this.sendFile(context);
                break;
            }
            case 1: {
                this.sendInputStream(context);
            }
        }
    }

    protected void sendBytes(RoutingContext context) {
        BaseVo.fillContentType(this.contentType, context.request().response()).putHeader(HttpHeader.CONTENT_DISPOSITION.toString(), this.contentDisposition);
        this.writeBytes(context.response().putHeader(HttpHeader.CONTENT_LENGTH.toString(), String.valueOf(this.bytes.length)), 0);
    }

    protected void sendInputStream(RoutingContext context) {
        BaseVo.fillContentType(this.contentType, context.request().response()).putHeader(HttpHeader.CONTENT_DISPOSITION.toString(), this.contentDisposition);
        this.writeInputStream(context.response().setChunked(true));
    }

    protected void sendFile(RoutingContext context) throws NotFoundException {
        context.request().response().putHeader(HttpHeader.CONTENT_DISPOSITION.toString(), this.contentDisposition);
        this.writeFile(context);
    }

    private void writeBytes(HttpServerResponse response, int startIndex) {
        int endIndex = startIndex + 1024000;
        if (endIndex >= this.bytes.length) {
            response.end(Buffer.buffer((byte[])Arrays.copyOfRange(this.bytes, startIndex, this.bytes.length)));
        } else {
            response.write((Object)Buffer.buffer((byte[])Arrays.copyOfRange(this.bytes, startIndex, endIndex)), r -> {
                if (r.succeeded()) {
                    this.writeBytes(response, endIndex);
                }
            });
        }
    }

    private void writeInputStream(HttpServerResponse response) {
        byte[] b = new byte[1024000];
        Integer endIndex = (Integer)ScxExceptionHelper.wrap(() -> this.inputStream.read(b));
        if (endIndex == -1) {
            response.end();
        } else {
            response.write((Object)Buffer.buffer((byte[])Arrays.copyOfRange(b, 0, (int)endIndex)), r -> {
                if (r.succeeded()) {
                    this.writeInputStream(response);
                }
            });
        }
    }

    private void writeFile(RoutingContext context) throws NotFoundException {
        SendFileHelper.SEND_FILE_HELPER.sendStatic(context, context.vertx().fileSystem(), this.path.toString(), false);
    }

    static enum Type {
        PATH,
        INPUT_STREAM,
        BYTE_ARRAY;

    }
}

