/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.ScxTCPClient;
import cool.scx.net.ScxTCPClientOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.ScxTCPSocketImpl;
import cool.scx.net.proxy.Proxy;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.ssl.SSLSocket;

public class ScxTCPClientImpl
implements ScxTCPClient {
    private final ScxTCPClientOptions options;

    public ScxTCPClientImpl() {
        this(new ScxTCPClientOptions());
    }

    public ScxTCPClientImpl(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        try {
            TLS tls = this.options.tls();
            Proxy proxy = this.options.proxy();
            Socket socket = tls != null && tls.enabled() ? tls.createSocket() : new Socket();
            socket.connect(endpoint);
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.startHandshake();
            }
            return new ScxTCPSocketImpl(socket);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

