/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.ClassicTCPSocket;
import cool.scx.net.ScxTCPServer;
import cool.scx.net.ScxTCPServerOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocket;

public class ClassicTCPServer
implements ScxTCPServer {
    private final ScxTCPServerOptions options;
    private final Thread serverThread;
    private Consumer<ScxTCPSocket> connectHandler;
    private ServerSocket serverSocket;
    private boolean running;

    public ClassicTCPServer() {
        this(new ScxTCPServerOptions());
    }

    public ClassicTCPServer(ScxTCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().unstarted(this::listen);
    }

    @Override
    public ScxTCPServer onConnect(Consumer<ScxTCPSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException("Server is already running");
        }
        try {
            TLS tls = this.options.tls();
            this.serverSocket = tls != null && tls.enabled() ? tls.createServerSocket() : new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(this.options.port()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.serverThread.interrupt();
    }

    @Override
    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private void listen() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                Thread.ofVirtual().start(() -> {
                    try {
                        if (socket instanceof SSLSocket) {
                            SSLSocket sslSocket = (SSLSocket)socket;
                            sslSocket.startHandshake();
                        }
                        ClassicTCPSocket tcpSocket = new ClassicTCPSocket(socket);
                        this.connectHandler.accept(tcpSocket);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

