/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.io.NoMoreDataException;
import cool.scx.net.ScxTCPSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ClassicTCPSocket
implements ScxTCPSocket {
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;

    public ClassicTCPSocket(Socket socket) {
        this.socket = socket;
        try {
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.out.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.out.write(bytes, offset, length);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    @Override
    public void write(Path path, long offset, long length) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
            raf.seek(offset);
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int i = raf.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                if (i == -1) {
                    break;
                }
                this.out.write(buffer, 0, i);
                length -= (long)i;
            }
        }
    }

    @Override
    public void write(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            is.transferTo(this.out);
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.remaining()];
        int bytesRead = this.read(bytes, 0, bytes.length);
        buffer.put(bytes, 0, bytesRead);
        return bytesRead;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.in.read(bytes, offset, length);
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.in.read(bytes);
    }

    @Override
    public void read(Path path, long offset, long length, OpenOption ... options) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
            raf.seek(offset);
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int i = this.in.read(buffer);
                if (i == -1) {
                    break;
                }
                raf.write(buffer, 0, i);
                length -= (long)i;
            }
        }
    }

    @Override
    public void read(Path path, OpenOption ... options) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, options);){
            this.in.transferTo(os);
        }
    }

    @Override
    public byte[] read(int maxLength) throws IOException, NoMoreDataException {
        byte[] buffer = new byte[maxLength];
        int bytesRead = this.in.read(buffer);
        if (bytesRead == -1) {
            throw new NoMoreDataException();
        }
        if (bytesRead == maxLength) {
            return buffer;
        }
        byte[] data = new byte[bytesRead];
        System.arraycopy(buffer, 0, data, 0, bytesRead);
        return data;
    }

    @Override
    public boolean isOpen() throws IOException {
        return !this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }
}

