/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.io.NoMoreDataException;
import cool.scx.net.ScxTCPSocket;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class PlainTCPSocket
implements ScxTCPSocket {
    private final SocketChannel socketChannel;

    public PlainTCPSocket(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            this.socketChannel.write(buffer);
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public void write(Path path, long offset, long length) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            while (length > 0L) {
                long i = fileChannel.transferTo(offset, length, this.socketChannel);
                if (i == 0L) {
                    break;
                }
                offset += i;
                length -= i;
            }
        }
    }

    @Override
    public void write(Path path) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
            long i;
            long offset = 0L;
            while ((i = fileChannel.transferTo(offset, Long.MAX_VALUE, this.socketChannel)) != 0L) {
                offset += i;
            }
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.socketChannel.read(buffer);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.read(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(ByteBuffer.wrap(bytes));
    }

    @Override
    public void read(Path path, long offset, long length, OpenOption ... options) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, options);){
            while (length > 0L) {
                long i = fileChannel.transferFrom(this.socketChannel, offset, length);
                if (i == 0L) {
                    break;
                }
                offset += i;
                length -= i;
            }
        }
    }

    @Override
    public void read(Path path, OpenOption ... options) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, options);){
            long i;
            long offset = 0L;
            while ((i = fileChannel.transferFrom(this.socketChannel, offset, Long.MAX_VALUE)) != 0L) {
                offset += i;
            }
        }
    }

    @Override
    public byte[] read(int maxLength) throws IOException, NoMoreDataException {
        ByteBuffer buffer = ByteBuffer.allocate(maxLength);
        int bytesRead = this.read(buffer);
        if (bytesRead == -1) {
            throw new NoMoreDataException();
        }
        if (bytesRead == maxLength) {
            return buffer.array();
        }
        byte[] data = new byte[bytesRead];
        System.arraycopy(buffer.array(), 0, data, 0, data.length);
        return data;
    }

    @Override
    public void close() throws IOException {
        this.socketChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public SocketAddress remoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }
}

