/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.PlainTCPSocket;
import cool.scx.net.ScxTCPClient;
import cool.scx.net.ScxTCPClientOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.TLSTCPSocket;
import cool.scx.net.proxy.Proxy;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public class TCPClient
implements ScxTCPClient {
    private final ScxTCPClientOptions options;

    public TCPClient() {
        this(new ScxTCPClientOptions());
    }

    public TCPClient(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        try {
            TLS tls = this.options.tls();
            Proxy proxy = this.options.proxy();
            if (tls != null && tls.enabled()) {
                SSLEngine sslEngine = tls.sslContext().createSSLEngine();
                sslEngine.setUseClientMode(true);
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.connect(endpoint);
                TLSTCPSocket socket = new TLSTCPSocket(socketChannel, sslEngine);
                try {
                    socket.startHandshake();
                    return socket;
                }
                catch (Exception e) {
                    socketChannel.close();
                    throw e;
                }
            }
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.connect(endpoint);
            return new PlainTCPSocket(socketChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

