/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.PlainTCPSocket;
import cool.scx.net.ScxTCPServer;
import cool.scx.net.ScxTCPServerOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.TLSTCPSocket;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;

public class TCPServer
implements ScxTCPServer {
    private final ScxTCPServerOptions options;
    private final Thread serverThread;
    private Consumer<ScxTCPSocket> connectHandler;
    private ServerSocketChannel serverSocketChannel;
    private boolean running;

    public TCPServer() {
        this(new ScxTCPServerOptions());
    }

    public TCPServer(ScxTCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().unstarted(this::listen);
    }

    @Override
    public ScxTCPServer onConnect(Consumer<ScxTCPSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException("Server is already running");
        }
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.bind(new InetSocketAddress(this.options.port()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocketChannel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.serverThread.interrupt();
    }

    @Override
    public int port() {
        try {
            InetSocketAddress localAddress = (InetSocketAddress)this.serverSocketChannel.getLocalAddress();
            return localAddress.getPort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void listen() {
        while (this.running) {
            try {
                SocketChannel socketChannel = this.serverSocketChannel.accept();
                Thread.ofVirtual().start(() -> {
                    try {
                        TLS tls = this.options.tls();
                        if (tls != null && tls.enabled()) {
                            SSLEngine sslEngine = tls.sslContext().createSSLEngine();
                            sslEngine.setUseClientMode(false);
                            TLSTCPSocket tcpSocket = new TLSTCPSocket(socketChannel, sslEngine);
                            try {
                                tcpSocket.startHandshake();
                                this.connectHandler.accept(tcpSocket);
                            }
                            catch (Exception e) {
                                socketChannel.close();
                                e.printStackTrace();
                            }
                        } else {
                            PlainTCPSocket tcpSocket = new PlainTCPSocket(socketChannel);
                            this.connectHandler.accept(tcpSocket);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

