/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.io.BufferHelper;
import cool.scx.io.ByteChannelDataSupplier;
import cool.scx.io.LinkedDataReader;
import cool.scx.io.NoMoreDataException;
import cool.scx.net.ScxTCPSocket;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class TLSTCPSocket
implements ScxTCPSocket {
    private final SocketChannel socketChannel;
    private final SSLEngine sslEngine;
    private final LinkedDataReader dataReader;
    private final LinkedDataReader rawReader;
    private final int packetBufferSize;
    private final int applicationBufferSize;
    private final ByteBuffer writeBuffer;

    public TLSTCPSocket(SocketChannel socketChannel, SSLEngine sslEngine) {
        this.socketChannel = socketChannel;
        this.sslEngine = sslEngine;
        this.packetBufferSize = sslEngine.getSession().getPacketBufferSize();
        this.applicationBufferSize = sslEngine.getSession().getApplicationBufferSize();
        this.rawReader = new LinkedDataReader((Supplier)new ByteChannelDataSupplier((ByteChannel)socketChannel, this.applicationBufferSize));
        this.dataReader = new LinkedDataReader(this::decodeDataSupplier);
        this.writeBuffer = ByteBuffer.allocateDirect(this.packetBufferSize);
    }

    public void startHandshake() throws IOException {
        this.sslEngine.beginHandshake();
        ByteBuffer peerAppData = ByteBuffer.allocate(this.applicationBufferSize);
        ByteBuffer readBuffer = ByteBuffer.allocate(this.packetBufferSize);
        block6: while (true) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
            switch (handshakeStatus) {
                case FINISHED: 
                case NOT_HANDSHAKING: {
                    return;
                }
                case NEED_UNWRAP: {
                    if (this.socketChannel.read(readBuffer) == -1) {
                        throw new IOException("Channel closed during handshake");
                    }
                    readBuffer.flip();
                    while (readBuffer.hasRemaining()) {
                        SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(readBuffer, peerAppData);
                    }
                    readBuffer.compact();
                    break;
                }
                case NEED_WRAP: {
                    this.writeBuffer.clear();
                    SSLEngineResult wrapResult = this.sslEngine.wrap(ByteBuffer.allocate(0), this.writeBuffer);
                    this.writeBuffer.flip();
                    while (true) {
                        if (!this.writeBuffer.hasRemaining()) continue block6;
                        this.socketChannel.write(this.writeBuffer);
                    }
                }
                case NEED_TASK: {
                    while (true) {
                        Runnable task;
                        if ((task = this.sslEngine.getDelegatedTask()) == null) continue block6;
                        task.run();
                    }
                }
                default: {
                    throw new IllegalStateException("Unexpected handshake status: " + String.valueOf((Object)handshakeStatus));
                }
            }
        }
    }

    public LinkedDataReader.Node decodeDataSupplier() {
        try {
            ByteBuffer encryptedBuffer = ByteBuffer.allocate(this.packetBufferSize);
            ByteBuffer decryptedBuffer = ByteBuffer.allocate(this.applicationBufferSize);
            encryptedBuffer = BufferHelper.putBytes((ByteBuffer)encryptedBuffer, (byte[])this.rawReader.fastRead(this.packetBufferSize)).flip();
            while (encryptedBuffer.hasRemaining()) {
                SSLEngineResult result = this.sslEngine.unwrap(encryptedBuffer, decryptedBuffer);
                switch (result.getStatus()) {
                    case OK: {
                        break;
                    }
                    case BUFFER_OVERFLOW: {
                        decryptedBuffer = BufferHelper.expandBuffer((ByteBuffer)decryptedBuffer);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        encryptedBuffer = BufferHelper.putBytes((ByteBuffer)encryptedBuffer.compact(), (byte[])this.rawReader.fastRead(this.packetBufferSize)).flip();
                        break;
                    }
                }
            }
            decryptedBuffer.flip();
            return new LinkedDataReader.Node(decryptedBuffer.array(), decryptedBuffer.position(), decryptedBuffer.limit());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        while (buffer.hasRemaining()) {
            this.writeBuffer.clear();
            SSLEngineResult result = this.sslEngine.wrap(buffer, this.writeBuffer);
            SSLEngineResult.Status status = result.getStatus();
            switch (status) {
                case OK: {
                    this.writeBuffer.flip();
                    while (this.writeBuffer.hasRemaining()) {
                        this.socketChannel.write(this.writeBuffer);
                    }
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new IOException("SSLEngine wrap \u9047\u5230 BUFFER_OVERFLOW");
                }
                case BUFFER_UNDERFLOW: {
                    throw new IOException("SSLEngine wrap \u9047\u5230 BUFFER_UNDERFLOW");
                }
                case CLOSED: {
                    throw new IOException("SSLEngine wrap \u9047\u5230 CLOSED");
                }
            }
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.write(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public void write(Path path, long offset, long length) throws IOException {
    }

    @Override
    public void write(Path path) throws IOException {
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        byte[] bytes = this.dataReader.tryRead(buffer.remaining());
        buffer.put(bytes);
        return bytes.length;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.read(ByteBuffer.wrap(bytes, offset, length));
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(ByteBuffer.wrap(bytes));
    }

    @Override
    public void read(Path path, long offset, long length, OpenOption ... options) throws IOException {
    }

    @Override
    public void read(Path path, OpenOption ... options) throws IOException {
    }

    @Override
    public byte[] read(int maxLength) throws IOException, NoMoreDataException {
        return this.dataReader.tryRead(maxLength);
    }

    @Override
    public void close() throws IOException {
        this.sslEngine.closeOutbound();
        if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.startHandshake();
        }
        this.socketChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public SocketAddress remoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }
}

