/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net.tls;

import cool.scx.net.tls.TLSHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class TLS {
    private final Path path;
    private final String password;
    private final KeyStore keyStore;
    private final KeyManagerFactory KeyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private final SSLContext sslContext;
    private final SSLServerSocketFactory serverSocketFactory;
    private final SSLSocketFactory socketFactory;
    private boolean enabled = true;

    public TLS(Path path, String password) {
        this.path = path;
        this.password = password;
        this.keyStore = TLSHelper.createKeyStore(path, password);
        this.KeyManagerFactory = TLSHelper.createKeyManagerFactory(this.keyStore, password);
        this.trustManagerFactory = TLSHelper.createTrustManagerFactory(this.keyStore);
        this.sslContext = TLSHelper.createSSLContext(this.KeyManagerFactory, this.trustManagerFactory);
        this.serverSocketFactory = this.sslContext.getServerSocketFactory();
        this.socketFactory = this.sslContext.getSocketFactory();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public TLS enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public ServerSocket createServerSocket() {
        try {
            return this.serverSocketFactory.createServerSocket();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Socket createSocket() {
        try {
            return this.socketFactory.createSocket();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

