/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.ScxTCPServer;
import cool.scx.net.ScxTCPServerOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.TCPSocket;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocket;

public class TCPServer
implements ScxTCPServer {
    private static final System.Logger logger = System.getLogger(TCPServer.class.getName());
    private final ScxTCPServerOptions options;
    private final Thread serverThread;
    private Consumer<ScxTCPSocket> connectHandler;
    private ServerSocket serverSocket;
    private boolean running;

    public TCPServer() {
        this(new ScxTCPServerOptions());
    }

    public TCPServer(ScxTCPServerOptions options) {
        this.options = options;
        this.serverThread = Thread.ofPlatform().unstarted(this::listen);
    }

    @Override
    public ScxTCPServer onConnect(Consumer<ScxTCPSocket> connectHandler) {
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException("\u670d\u52a1\u5668\u5df2\u5728\u8fd0\u884c !!!");
        }
        TLS tls = this.options.tls();
        try {
            this.serverSocket = tls != null && tls.enabled() ? tls.createServerSocket() : new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(this.options.port()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u542f\u52a8\u5931\u8d25 !!!", e);
        }
        this.running = true;
        this.serverThread.start();
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("\u5173\u95ed\u5931\u8d25 !!!", e);
        }
        this.serverThread.interrupt();
    }

    @Override
    public int port() {
        return this.serverSocket.getLocalPort();
    }

    private void listen() {
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                Thread.ofVirtual().start(() -> this.handle(socket));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void handle(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            try {
                sslSocket.startHandshake();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "SSL \u63e1\u624b\u5931\u8d25 : " + e.getMessage());
                try {
                    socket.close();
                }
                catch (IOException ce) {
                    e.addSuppressed(ce);
                }
                return;
            }
        }
        TCPSocket tcpSocket = new TCPSocket(socket);
        this.connectHandler.accept(tcpSocket);
    }
}

