/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.net;

import cool.scx.net.ScxTCPClient;
import cool.scx.net.ScxTCPClientOptions;
import cool.scx.net.ScxTCPSocket;
import cool.scx.net.TCPSocket;
import cool.scx.net.proxy.Proxy;
import cool.scx.net.tls.TLS;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.ssl.SSLSocket;

public class TCPClient
implements ScxTCPClient {
    private static final System.Logger logger = System.getLogger(TCPClient.class.getName());
    private final ScxTCPClientOptions options;

    public TCPClient() {
        this(new ScxTCPClientOptions());
    }

    public TCPClient(ScxTCPClientOptions options) {
        this.options = options;
    }

    @Override
    public ScxTCPSocket connect(SocketAddress endpoint) {
        Socket socket;
        block6: {
            TLS tls = this.options.tls();
            Proxy proxy = this.options.proxy();
            try {
                socket = tls != null && tls.enabled() ? tls.createSocket() : new Socket();
                socket.connect(endpoint);
                if (!(socket instanceof SSLSocket)) break block6;
                SSLSocket sslSocket = (SSLSocket)socket;
                try {
                    sslSocket.startHandshake();
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "SSL \u63e1\u624b\u5931\u8d25 : " + e.getMessage());
                    try {
                        sslSocket.close();
                    }
                    catch (IOException ce) {
                        e.addSuppressed(ce);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "\u8fde\u63a5\u5931\u8d25 : ", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
        return new TCPSocket(socket);
    }
}

