/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper;

import cool.scx.common.constant.DateTimeFormatters;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.collection.CollectionNodeMapper;
import cool.scx.object.mapper.enumeration.EnumNodeMapper;
import cool.scx.object.mapper.map.MapNodeMapper;
import cool.scx.object.mapper.math.BigDecimalNodeMapper;
import cool.scx.object.mapper.math.BigIntegerNodeMapper;
import cool.scx.object.mapper.node.ArrayNodeNodeMapper;
import cool.scx.object.mapper.node.BigDecimalNodeNodeMapper;
import cool.scx.object.mapper.node.BigIntegerNodeNodeMapper;
import cool.scx.object.mapper.node.BooleanNodeNodeMapper;
import cool.scx.object.mapper.node.DoubleNodeNodeMapper;
import cool.scx.object.mapper.node.FloatNodeNodeMapper;
import cool.scx.object.mapper.node.IntNodeNodeMapper;
import cool.scx.object.mapper.node.LongNodeNodeMapper;
import cool.scx.object.mapper.node.NodeNodeMapper;
import cool.scx.object.mapper.node.NullNodeNodeMapper;
import cool.scx.object.mapper.node.NumericNodeNodeMapper;
import cool.scx.object.mapper.node.ObjectNodeNodeMapper;
import cool.scx.object.mapper.node.TextNodeNodeMapper;
import cool.scx.object.mapper.node.ValueNodeNodeMapper;
import cool.scx.object.mapper.object.ObjectArrayNodeMapper;
import cool.scx.object.mapper.object.ObjectNodeMapper;
import cool.scx.object.mapper.primitive.BooleanNodeMapper;
import cool.scx.object.mapper.primitive.ByteNodeMapper;
import cool.scx.object.mapper.primitive.CharNodeMapper;
import cool.scx.object.mapper.primitive.DoubleNodeMapper;
import cool.scx.object.mapper.primitive.FloatNodeMapper;
import cool.scx.object.mapper.primitive.IntNodeMapper;
import cool.scx.object.mapper.primitive.LongNodeMapper;
import cool.scx.object.mapper.primitive.ShortNodeMapper;
import cool.scx.object.mapper.primitive_array.BooleanArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.ByteArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.CharArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.DoubleArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.FloatArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.IntArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.LongArrayNodeMapper;
import cool.scx.object.mapper.primitive_array.ShortArrayNodeMapper;
import cool.scx.object.mapper.record.RecordNodeMapper;
import cool.scx.object.mapper.string.StringNodeMapper;
import cool.scx.object.mapper.time.LocalDateNodeMapper;
import cool.scx.object.mapper.time.LocalDateTimeNodeMapper;
import cool.scx.object.mapper.time.LocalTimeNodeMapper;
import cool.scx.object.mapper.untyped.UntypedNodeMapper;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.NumberNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.node.ValueNode;
import cool.scx.reflect.ArrayTypeInfo;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.PrimitiveTypeInfo;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class NodeMapperSelector {
    private final Map<Object, NodeMapper<?>> NODE_MAPPER_MAP = new HashMap();

    public NodeMapperSelector() {
        this.registerNodeMapper(Byte.TYPE, new ByteNodeMapper(true));
        this.registerNodeMapper(Short.TYPE, new ShortNodeMapper(true));
        this.registerNodeMapper(Integer.TYPE, new IntNodeMapper(true));
        this.registerNodeMapper(Long.TYPE, new LongNodeMapper(true));
        this.registerNodeMapper(Float.TYPE, new FloatNodeMapper(true));
        this.registerNodeMapper(Double.TYPE, new DoubleNodeMapper(true));
        this.registerNodeMapper(Boolean.TYPE, new BooleanNodeMapper(true));
        this.registerNodeMapper(Character.TYPE, new CharNodeMapper(true));
        this.registerNodeMapper(Byte.class, new ByteNodeMapper(false));
        this.registerNodeMapper(Short.class, new ShortNodeMapper(false));
        this.registerNodeMapper(Integer.class, new IntNodeMapper(false));
        this.registerNodeMapper(Long.class, new LongNodeMapper(false));
        this.registerNodeMapper(Float.class, new FloatNodeMapper(false));
        this.registerNodeMapper(Double.class, new DoubleNodeMapper(false));
        this.registerNodeMapper(Boolean.class, new BooleanNodeMapper(false));
        this.registerNodeMapper(Character.class, new CharNodeMapper(false));
        this.registerNodeMapper(String.class, new StringNodeMapper());
        this.registerNodeMapper(BigInteger.class, new BigIntegerNodeMapper());
        this.registerNodeMapper(BigDecimal.class, new BigDecimalNodeMapper());
        this.registerNodeMapper(byte[].class, new ByteArrayNodeMapper());
        this.registerNodeMapper(short[].class, new ShortArrayNodeMapper());
        this.registerNodeMapper(int[].class, new IntArrayNodeMapper());
        this.registerNodeMapper(long[].class, new LongArrayNodeMapper());
        this.registerNodeMapper(float[].class, new FloatArrayNodeMapper());
        this.registerNodeMapper(double[].class, new DoubleArrayNodeMapper());
        this.registerNodeMapper(boolean[].class, new BooleanArrayNodeMapper());
        this.registerNodeMapper(char[].class, new CharArrayNodeMapper());
        this.registerNodeMapper(LocalDateTime.class, new LocalDateTimeNodeMapper(DateTimeFormatters.yyyy_MM_dd_HH_mm_ss));
        this.registerNodeMapper(LocalDate.class, new LocalDateNodeMapper(DateTimeFormatters.yyyy_MM_dd));
        this.registerNodeMapper(LocalTime.class, new LocalTimeNodeMapper(DateTimeFormatters.HH_mm_ss));
        this.registerNodeMapper(IntNode.class, new IntNodeNodeMapper());
        this.registerNodeMapper(LongNode.class, new LongNodeNodeMapper());
        this.registerNodeMapper(FloatNode.class, new FloatNodeNodeMapper());
        this.registerNodeMapper(DoubleNode.class, new DoubleNodeNodeMapper());
        this.registerNodeMapper(BigIntegerNode.class, new BigIntegerNodeNodeMapper());
        this.registerNodeMapper(BigDecimalNode.class, new BigDecimalNodeNodeMapper());
        this.registerNodeMapper(TextNode.class, new TextNodeNodeMapper());
        this.registerNodeMapper(BooleanNode.class, new BooleanNodeNodeMapper());
        this.registerNodeMapper(ValueNode.class, new ValueNodeNodeMapper());
        this.registerNodeMapper(NumberNode.class, new NumericNodeNodeMapper());
        this.registerNodeMapper(NullNode.class, new NullNodeNodeMapper());
        this.registerNodeMapper(ArrayNode.class, new ArrayNodeNodeMapper());
        this.registerNodeMapper(ObjectNode.class, new ObjectNodeNodeMapper());
        this.registerNodeMapper(Node.class, new NodeNodeMapper());
        this.registerNodeMapper(Object.class, new UntypedNodeMapper());
    }

    public <T> void registerNodeMapper(TypeInfo type, NodeMapper<T> typeHandler) {
        this.NODE_MAPPER_MAP.put(type, typeHandler);
    }

    public <T> void registerNodeMapper(Class<T> type, NodeMapper<T> typeHandler) {
        this.NODE_MAPPER_MAP.put(type, typeHandler);
        this.NODE_MAPPER_MAP.put(ScxReflect.typeOf(type), typeHandler);
    }

    public <T> NodeMapper<T> findNodeMapper(TypeInfo type) {
        NodeMapper<?> nodeMapper = this.NODE_MAPPER_MAP.get(type);
        if (nodeMapper != null) {
            return nodeMapper;
        }
        NodeMapper<?> newNodeMapper = this.createNodeMapper(type);
        this.registerNodeMapper(type, newNodeMapper);
        return newNodeMapper;
    }

    public <T> NodeMapper<T> findNodeMapper(Class<T> type) {
        NodeMapper<?> nodeMapper = this.NODE_MAPPER_MAP.get(type);
        if (nodeMapper != null) {
            return nodeMapper;
        }
        NodeMapper<?> newNodeMapper = this.createNodeMapper(type);
        this.registerNodeMapper(type, newNodeMapper);
        return newNodeMapper;
    }

    private NodeMapper<?> createNodeMapper(Object type) throws NodeMappingException {
        TypeInfo typeInfo;
        Object object = type;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        TypeInfo typeInfo2 = typeInfo = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeInfo.class, Class.class}, (Object)object2, n)) {
            case 0 -> {
                TypeInfo t;
                yield t = (TypeInfo)object2;
            }
            case 1 -> {
                Class c = (Class)object2;
                yield ScxReflect.typeOf((Class)c);
            }
            default -> throw new NodeMappingException("Type \u7c7b\u578b\u5f02\u5e38");
        });
        Objects.requireNonNull(typeInfo2);
        object2 = typeInfo2;
        n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTypeInfo.class, ArrayTypeInfo.class, ClassInfo.class}, (TypeInfo)object2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new NodeMappingException("\u4e0d\u53ef\u8fbe\u5f02\u5e38 !!!");
            }
            case 1: {
                ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)object2;
                TypeInfo componentType = arrayTypeInfo.componentType();
                NodeMapper<Object> componentNodeMapper = this.findNodeMapper(componentType);
                return new ObjectArrayNodeMapper(arrayTypeInfo, componentNodeMapper);
            }
            case 2: 
        }
        ClassInfo classInfo = (ClassInfo)object2;
        if (Map.class.isAssignableFrom(typeInfo.rawClass())) {
            return new MapNodeMapper(classInfo, this);
        }
        if (Collection.class.isAssignableFrom(classInfo.rawClass())) {
            return new CollectionNodeMapper(classInfo, this);
        }
        return switch (classInfo.classKind()) {
            default -> throw new MatchException(null, null);
            case ClassKind.RECORD -> new RecordNodeMapper(classInfo);
            case ClassKind.CLASS -> {
                if (classInfo.isAbstract()) {
                    throw new NodeMappingException("\u65e0\u6cd5\u5904\u7406\u62bd\u8c61\u7c7b: " + String.valueOf(classInfo));
                }
                yield new ObjectNodeMapper(classInfo);
            }
            case ClassKind.ENUM -> new EnumNodeMapper(classInfo);
            case ClassKind.ANNOTATION -> throw new NodeMappingException("\u65e0\u6cd5\u5904\u7406\u6ce8\u89e3: " + String.valueOf(classInfo));
            case ClassKind.INTERFACE -> throw new NodeMappingException("\u65e0\u6cd5\u5904\u7406\u63a5\u53e3: " + String.valueOf(classInfo));
        };
    }
}

