/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.enumeration;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import cool.scx.reflect.ClassInfo;

public final class EnumNodeMapper<E extends Enum<E>>
implements NodeMapper<E> {
    private final ClassInfo classInfo;
    private final Class<E> enumClass;

    public EnumNodeMapper(ClassInfo classInfo) {
        this.classInfo = classInfo;
        this.enumClass = classInfo.enumClass().rawClass();
    }

    @Override
    public Node toNode(E value, ToNodeContext context) {
        return new TextNode(((Enum)value).name());
    }

    @Override
    public E fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String value = textNode.value();
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }
}

