/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.math;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;
import java.math.BigDecimal;

public final class BigDecimalNodeMapper
implements NodeMapper<BigDecimal> {
    @Override
    public Node toNode(BigDecimal value, ToNodeContext context) {
        return new BigDecimalNode(value);
    }

    @Override
    public BigDecimal fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asBigDecimal();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

