/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.math;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;
import java.math.BigInteger;

public final class BigIntegerNodeMapper
implements NodeMapper<BigInteger> {
    @Override
    public Node toNode(BigInteger value, ToNodeContext context) {
        return new BigIntegerNode(value);
    }

    @Override
    public BigInteger fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asBigInteger();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

