/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.node;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class BigDecimalNodeNodeMapper
implements NodeMapper<BigDecimalNode> {
    @Override
    public Node toNode(BigDecimalNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public BigDecimalNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof BigDecimalNode) {
            BigDecimalNode bigDecimalNode = (BigDecimalNode)node;
            return bigDecimalNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return new BigDecimalNode(valueNode.asBigDecimal());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

