/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.node;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class BooleanNodeNodeMapper
implements NodeMapper<BooleanNode> {
    @Override
    public Node toNode(BooleanNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public BooleanNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)node;
            return booleanNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            return BooleanNode.of(valueNode.asBoolean());
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

