/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.node;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class DoubleNodeNodeMapper
implements NodeMapper<DoubleNode> {
    @Override
    public Node toNode(DoubleNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public DoubleNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof DoubleNode) {
            DoubleNode doubleNode = (DoubleNode)node;
            return doubleNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return new DoubleNode(valueNode.asDouble());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

