/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.node;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class FloatNodeNodeMapper
implements NodeMapper<FloatNode> {
    @Override
    public Node toNode(FloatNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public FloatNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof FloatNode) {
            FloatNode intNode = (FloatNode)node;
            return intNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return new FloatNode(valueNode.asFloat());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

