/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.node;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NumberNode;
import cool.scx.object.node.TextNode;

public final class NumericNodeNodeMapper
implements NodeMapper<NumberNode> {
    @Override
    public Node toNode(NumberNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public NumberNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)node;
            return numberNode.deepCopy();
        }
        if (node instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)node;
            return new IntNode(booleanNode.asInt());
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return new IntNode(textNode.asInt());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

