/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.object;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.reflect.ArrayTypeInfo;

public final class ObjectArrayNodeMapper
implements NodeMapper<Object[]> {
    private final ArrayTypeInfo arrayTypeInfo;
    private final NodeMapper<Object> componentNodeMapper;

    public ObjectArrayNodeMapper(ArrayTypeInfo arrayTypeInfo, NodeMapper<Object> componentNodeMapper) {
        this.arrayTypeInfo = arrayTypeInfo;
        this.componentNodeMapper = componentNodeMapper;
    }

    @Override
    public Node toNode(Object[] value, ToNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode = new ArrayNode(value.length);
        int i = 0;
        for (Object a : value) {
            arrayNode.add(context.toNode(a, i));
            ++i;
        }
        return arrayNode;
    }

    @Override
    public Object[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            Object[] result = (Object[])this.arrayTypeInfo.newArray(arrayNode.size());
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.componentNodeMapper.fromNode(e, context);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

