/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.object;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public final class ObjectNodeMapper
implements NodeMapper<Object> {
    private final ClassInfo classInfo;
    private final ConstructorInfo defaultConstructor;
    private final FieldInfo[] readableFields;
    private final FieldInfo[] writableFields;

    public ObjectNodeMapper(ClassInfo classInfo) {
        this.classInfo = classInfo;
        this.defaultConstructor = this.classInfo.defaultConstructor();
        this.readableFields = ObjectNodeMapper.filterReadableFields(this.classInfo);
        this.writableFields = ObjectNodeMapper.filterWritableFields(this.readableFields);
    }

    private static FieldInfo[] filterReadableFields(ClassInfo classInfo) {
        return (FieldInfo[])Arrays.stream(classInfo.allFields()).filter(c -> !c.isStatic() && c.accessModifier() == AccessModifier.PUBLIC).peek(c -> c.setAccessible(true)).toArray(FieldInfo[]::new);
    }

    private static FieldInfo[] filterWritableFields(FieldInfo[] readableFields) {
        return (FieldInfo[])Arrays.stream(readableFields).filter(c -> !c.isFinal()).toArray(FieldInfo[]::new);
    }

    private static Object getFieldValue(FieldInfo fieldInfo, Object value) throws NodeMappingException {
        try {
            return fieldInfo.get(value);
        }
        catch (IllegalAccessException e) {
            throw new NodeMappingException(e);
        }
    }

    private static void setFieldValue(FieldInfo fieldInfo, Object object, Object value) throws NodeMappingException {
        try {
            fieldInfo.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new NodeMappingException(e);
        }
    }

    @Override
    public Node toNode(Object objectValue, ToNodeContext context) throws NodeMappingException {
        ObjectNode objectNode = new ObjectNode();
        for (FieldInfo fieldInfo : this.readableFields) {
            String name = fieldInfo.name();
            Object value = ObjectNodeMapper.getFieldValue(fieldInfo, objectValue);
            if (value == null && context.options().ignoreNullValue()) continue;
            objectNode.put(name, context.toNode(value, name));
        }
        return objectNode;
    }

    @Override
    public Object fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            Object object = this.newInstance();
            for (FieldInfo fieldInfo : this.writableFields) {
                Node tempNode = objectNode.get(fieldInfo.name());
                if (tempNode == null) {
                    tempNode = NullNode.NULL;
                }
                Object v = context.fromNode(tempNode, fieldInfo.fieldType());
                ObjectNodeMapper.setFieldValue(fieldInfo, object, v);
            }
            return object;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    public Object newInstance() throws NodeMappingException {
        if (this.defaultConstructor == null) {
            throw new NodeMappingException("\u672a\u627e\u5230\u53ef\u7528\u7684\u6784\u9020\u51fd\u6570: " + String.valueOf(this.classInfo));
        }
        if (this.defaultConstructor.accessModifier() != AccessModifier.PUBLIC) {
            throw new NodeMappingException("\u672a\u627e\u5230\u53ef\u7528\u7684 public \u6784\u9020\u51fd\u6570: " + String.valueOf(this.classInfo));
        }
        try {
            return this.defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new NodeMappingException(e);
        }
    }
}

