/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.TextNode;

public final class CharNodeMapper
implements NodeMapper<Character> {
    private final boolean isPrimitive;

    public CharNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Character value, ToNodeContext context) {
        return new TextNode(value.toString());
    }

    @Override
    public Character fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node == NullNode.NULL) {
            return this.isPrimitive ? Character.valueOf('\u0000') : null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String text = textNode.asText();
            if (text.length() == 1) {
                return Character.valueOf(text.charAt(0));
            }
            throw new NodeMappingException("String length must be 1 for char, got: " + text);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

